#!/usr/bin/python
# -*- coding: utf-8 -*-

#печать таблицы для анализа

import sys
import re
import math

import yt.wrapper as yt


#--- progress bar ---
def progress(count, total, status=''):
    bar_len = 60
    filled_len = int(round(bar_len * count / float(total)))

    percents = round(100.0 * count / float(total), 1)
    bar = '■' * filled_len + '-' * (bar_len - filled_len)

    sys.stderr.write('[%s] %s%s ...%s\r' % (bar, percents, '%', status))
    sys.stderr.flush()


#--- поиск начала домена в таблице ---
def domain_search(table, domain_search, pat_re):
    input = table #исходная таблица
    row_count = yt.row_count(input)

    low = 0
    hi = row_count - 1
    steps = int(math.ceil(math.log(row_count, 2))) + 1 #число итераций в бинарном поиске
    step = 0;
    while low <= hi: #бинарный поиск урла в таблице
        mid = int((low + hi) / 2)
        input_range = input + '[#' + str(mid) + ':#' + str(mid+1) + ']' #прямой доступ к одной записи
        rec = next(yt.read_table(input_range, raw=False)) #итератор

        step += 1
        #------------------------------------------------
        progress(step, steps, status = 'Поиск в таблице')
        #------------------------------------------------

        url_re = pat_re.match(rec['url']) #парсинг урла
        if url_re is not None:
            domain = url_re.group(2) + '.' + url_re.group(3) #домен
            if url_re.group(1) is None: #ищем только в урлах с 'http(s)://'
                if domain < 'http://':
                    low = mid + 1
                elif domain > 'https://':
                    hi = mid - 1
            elif domain_search < domain:
                hi = mid - 1
            elif domain_search > domain:
                low = mid + 1
            else: #совпадение
                if low < hi: #продолжение поиска для выбора ПЕРВОЙ записи ИЗ ГРУППЫ одинаковых
                    hi = mid
                else:
                    mid = hi #индекс ПЕРВОЙ записи в найденной ГРУППЕ записей с одинаковым доменом
                    low = hi + 2 #ВЫХОД

    if low > row_count - 1:
        low = row_count - 1
    if hi < 0:
        hi = 0

    print >>sys.stderr
    if low == hi + 2: #поиск успешный
        input_range = input + '[#' + str(mid) + ':#' + str(mid+1) + ']' #прямой доступ к одной записи
        rec = next(yt.read_table(input_range, raw=False)) #итератор
        print >>sys.stderr, 'Нашли!: ' + str(mid) + '\t' + rec['url']

        return mid #индекс найденной записи в таблице
    else:
        print >>sys.stderr, 'Поиск неудачный :('
        return -1


#--- сохранение записей домена в таблице YT ---
def domain_save(input, output, ind, domain_search, pat_re, queries_max, url_max):
    DOMAIN = [] #записи найденного домена

    input_range = input + '[#' + str(ind) + ':]' #диапазон для просмотра таблицы от найденного места до конца
    prev_rec = None
    flag = 0
    url_count = 0
    for rec in yt.read_table(input_range, raw=False):
        url_re = pat_re.match(rec['url']) #парсинг урла
        if url_re is None:
            continue
        domain = url_re.group(2) + '.' + url_re.group(3) #домен
        if domain != domain_search:
            if flag == 0:
                continue
            break
        elif flag == 0:
            flag = 1

        if prev_rec is not None:
            if prev_rec['url'] == rec['url']:
                if D.has_key(rec['position']):
                    if D[rec['position']].has_key(rec['query']):
                        D[rec['position']][rec['query']] += 1
                    else:
                        D[rec['position']][rec['query']] = 1
                else:
                    D[rec['position']] = {rec['query']: 1}
            else:
                positions = D.keys()
                positions.sort() #сортировка по возрастанию позиции выдачи
                count = 0
                TRIO = []
                for position in positions:
                    queries = D[position].keys()
                    queries.sort() #сортировка запросов по алфавиту
                    for query in queries:
                        count += 1
                        if count > int(queries_max): #MAX число выводимых запросов
                            break
                        TRIO.append((position, query, D[position][query])) #кортеж: (позиция, запрос, частота)
                    if count > int(queries_max):
                        count = int(queries_max) #для вывода в выходную таблицу
                        break

                [DOMAIN.append({'title': title, 'url': url, 'meta': meta, 'text': text, 'position': TRIO[i][0], 'query': TRIO[i][1], 'freq': TRIO[i][2]}) for i in range(count)]

                url_count += 1
                if url_count > int(url_max):
                    break
                #-----------------------------------------------------------
                progress(url_count, int(url_max), status = 'Обработка URLs')
                #-----------------------------------------------------------

                prev_rec = rec
                title = prev_rec['title']
                url = prev_rec['url']
                meta = prev_rec['metaDescription']
                text = prev_rec['text']
                D = {}
                D[prev_rec['position']] = {prev_rec['query']: 1}
        else:
            prev_rec = rec
            title = prev_rec['title']
            url = prev_rec['url']
            meta = prev_rec['metaDescription']
            text = prev_rec['text']
            D = {}
            D[prev_rec['position']] = {prev_rec['query']: 1}
    print >>sys.stderr

    print >>sys.stderr, 'Создаем таблицу результатов...'
    yt.write_table(output, [rec for rec in DOMAIN], raw=False)


def main():
    input = '//home/catalogia/yuryz/queries_left_join' #исходная таблица

    pat = r'(https?:\/\/)?([\w\.%-]+)\.([a-z]{2,6}\.?)(\/[\w \.%-]*)*\/?' #парсинг урла
    pat_re = re.compile(pat)

    ind = domain_search(input, sys.argv[1], pat_re) #поиск начала домена в таблице (sys.argv[1] - домен)
    if ind < 0:
        return 1 #поиск неудачный
    #ind = 54875879 #***ТОЛЬКО ДЛЯ ОТЛАДКИ ***

    domain_save(input, sys.argv[4], ind, sys.argv[1], pat_re, sys.argv[2], sys.argv[3]) #сохранение записей домена в таблице YT (sys.argv[2] - MAX число печатаемых запросов, sys.argv[3] - MAX число обрабатываемых урлов в домене, sys.argv[4] - выходная таблица)


if __name__ == '__main__':
    main()
