#!/usr/bin/perl -w
#вычисление статистик запросов для урлов домена

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my %stat;
my $total = 0;

my ($key_prev, $freq_prev, $rank_beg, $rank_end) = ("", 0, 0, 0);
<STDIN>; #заголовки
while (<STDIN>) { #petrovich_ru_rank
    chomp;
    my ($url, $position, $query, $clicks, $freq, $search_count, $rank, $title,) = split /\t/; #sort: url, rank, query

    my $key = "$url";
    if ($key_prev ne "") {
        if ($key_prev eq $key) {
            $freq_prev++;
            $rank_end = $rank;
        } else {
            $stat{$freq_prev}++;
            $total += $freq_prev;
            #print "$key_prev\t$freq_prev\t$rank_beg\t$rank_end\t", sprintf("%.2f",  ($rank_beg - $rank_end + 0.01) * 100 / $freq_prev), "\n";

            $key_prev = "$url";
            $freq_prev = 1;
            $rank_beg = $rank;
            $rank_end = $rank;
        }
    } else {
        $key_prev = "$url";
        $freq_prev = 1;
        $rank_beg = $rank;
        $rank_end = $rank;
    }
}
$stat{$freq_prev}++;
$total += $freq_prev;
#print "$key_prev\t$freq_prev\t$rank_beg\t$rank_end\t", sprintf("%.2f",  ($rank_beg - $rank_end + 0.01) * 100 / $freq_prev), "\n";

print "TOTAL=$total\n";
my $mean = 0; #среднее
my $dev = 0; #СКО
my $sum = 0;
for (sort { $stat{$b} <=> $stat{$a} || $a <=> $b} keys %stat) {
    $mean += $_ * $stat{$_};
    $dev += ($_ ** 2) * $stat{$_};
    $sum += $stat{$_};
    print "$_\t$stat{$_}\n";
}
$mean = $mean / $sum;
printf "MEAN=%.2f\n", $mean;
$dev = sqrt($dev / $sum - $mean ** 2);
printf "DEVIATION=%.2f\n", $dev;
