#!/usr/bin/python
# -*- coding: utf-8 -*-

import yt.wrapper as yt


def mapper(rec):
    if rec['clicks'] > 0:
        rec['clicks'] = -rec['clicks']
        yield rec


def main():
    input = '//home/catalogia/yuryz/queries_left_join'
    output = '//tmp/yuryz/clicks'

    yt.run_map(mapper, input, output)
    yt.run_sort(output, sort_by=['clicks', 'url', 'position'])

    print yt.row_count(input)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
