#!/usr/bin/python
# -*- coding: utf-8 -*-

#копирование тблицы из YT в локальный каталог

import yt.wrapper as yt
import sys


#--- progress bar ---
def progress(count, total, status=''):
    bar_len = 50
    filled_len = int(round(bar_len * count / float(total)))

    percents = round(100.0 * count / float(total), 1)
    bar = '■' * filled_len + '-' * (bar_len - filled_len)

    sys.stderr.write('[%s] %s%s ...%s\r' % (bar, percents, '%', status))
    sys.stderr.flush()


def main():
    input = '//home/catalogia/yuryz/queries_only_uniq'
    total = yt.row_count(input)

    count = 0
    for row in yt.read_table(input, raw=False):
        count += 1
        if count % 1000 == 0:
            progress(count, total, status = 'Выгрузка таблицы')
        print row['query']
    print >>sys.stderr


if __name__ == '__main__':
    main()
