#!/usr/bin/perl -w

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

#use FindBin;
#use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
#use Utils::Graph3 qw(patch convert_to_graph1 mvgraph cpgraph rmgraph newgraph);
#use List::Util qw(first max maxstr min minstr reduce shuffle sum);
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({
    load_dicts   => 1,
    load_minicategs_light => 1, 
});

=z
my $bid = '2917289680';
my $bnr = $proj->bf->get_banner_by_id($bid);
my $phrase_list = $bnr->phl; #список фраз баннера
for my $phrase (@$phrase_list) {
    print "$phrase\n";
}
=cut

my $bid = '2917289680';
for my $i (0..21) {
    $bid++;
    my $bnr = $proj->bf->get_banner_by_id($bid);
    my $phrase_list = $bnr->phl; #список фраз баннера
    for my $phrase (@$phrase_list) {
        print "$bid\t$phrase\n";
        print $proj->phrase($phrase)->get_banner_prefiltered_phrase->text, "\n";
        print "--\n";
    }
}
print $proj->phrase('Только сейчас! 760 р! Motorola Корпус для V3i Dolce and Gabbana Gold - полный комплект!')->get_banner_prefiltered_phrase->text, "\n";

=z
while (my $line = <STDIN>) { #./data/uncat_bnrs_1kk
    chomp $line;
    my $bnr = $proj->bf->text2banner($line);
    my $phrase_list = $bnr->phl; #список фраз баннера
    for my $phrase (@$phrase_list) {
        print "$phrase\n";
    }   
}
=cut
