#!/usr/bin/perl -w
#категоризация баннеров с помощью landing page и ближайших соседей

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

#use FindBin;
#use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

my $worker = Utils::Worker->new;
$worker->{verbose}    = 1;
$worker->{num_processes}    = 12;

$worker->{file_input}       = "/home/yuryz/scripts/data/uncat_bnrs_1kk.active.tatr";
$worker->{file_output}      = "/home/yuryz/scripts/data/uncat_bnrs_1kk.active.tatr.cat";

$worker->{process_line}     = sub {
    my ($line, $fh) = @_;
    chomp $line;

    my $bnr = $proj->bf->text2banner($line);
    my $bnr_info = join("\t", $bnr->id, $bnr->banner_text_phrase->text, $bnr->url);

    my @bnr_categs = $bnr->get_categs_neighbors;
    print $fh "$bnr_info\t", join("\t", sort @bnr_categs), "\n";

};

$worker->process_data;
