#!/usr/bin/perl -w
#вычисление сходства кластеров внутри кампании

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';


my $clast_name1 = 'Услуги/Строительные услуги';
my $clast_name2 = 'Услуги/Услуги в сфере добычи и энергетики';
#$clast_name2 = 'NO_CATEGS';
#$clast_name2 = 'Товары/Промышленность';

my %dict1;
my %dict2;
my $dic1_sum = 0;
my $dic2_sum = 0;

while (<STDIN>) { #z1005177284
    chomp;
    my ($id, $text, $url, $categ) = split /\t/;
    next unless $categ =~ /^($clast_name1|$clast_name2)/;

    my $bnr_text = bnr_text_clean($text);
    if ($categ =~ /^$clast_name1/) {
        map { $dict1{$_}++, $dic1_sum++ } split / /, $bnr_text;
    } else {
        map { $dict2{$_}++, $dic2_sum++ } split / /, $bnr_text;
    }
}

for (sort { $dict1{$b} <=> $dict1{$a} || $a cmp $b } keys %dict1) {
    $dict1{$_} /= $dic1_sum;
}

for (sort { $dict2{$b} <=> $dict2{$a} || $a cmp $b } keys %dict2) {
    $dict2{$_} /= $dic2_sum;
}

my $simil = 0; #сходство
for (keys %dict1) {
    if ($dict2{$_}) {
        $simil += $dict1{$_} < $dict2{$_} ? $dict1{$_} : $dict2{$_};
    }
}

print "$clast_name1\n";
print "$clast_name2\n";
printf "simil=%.3f\n", $simil;


#--- очистка строки текста ---
sub bnr_text_clean {
    my ($text) = @_;

    my $valid_chars = qr/0-9a-zа-яё \-/; #допустимые символы
    
    $text = lc($text);
    $text =~ s/(?<=[\[\/])\.[$valid_chars]+?(?=[\]\/])/ /g; #атомы
    $text =~ s/-[$valid_chars]+?(?=( |[^$valid_chars]|$))/ /g; #минус слова
    $text =~ s/[^$valid_chars]/ /g;
    $text =~ s/^ +//;
    $text =~ s/ +$//;
    $text =~ s/ +/ /g;
    
    return $text;
}
