#!/usr/bin/env bash
# формирование словаря семантических ядер из баннеров Каталогии

#--- I. Первичная обработка баннеров
python bnrs_select.py 3 //home/catalogia/banners_extended //tmp/yuryz/bnrs_uniq #1 - обычные баннеры, 2 - омонимичные баннеры, 3 - те и другие
##python ksu_bnrs_select.py 3 //home/catalogia/banners_extended //tmp/yuryz/bnrs_uniq #1 - обычные баннеры, 2 - омонимичные баннеры, 3 - те и другие
perl bnrs_norm_main.pl //tmp/yuryz/bnrs_uniq //tmp/yuryz/bnrs_norm #(bnrs_norm_map.pl) - выделение и нормализация смыслового ядра баннеров
python bnrs_bid2int.py //tmp/yuryz/bnrs_norm //home/catalogia/users/yuryz/tmp/bnrs_norm

# --- II. Построение таблицы семантических ядер баннеров Каталогии yuryz/tmp/bnrs_norm_sense ---
python tf_idf_1.py #*** python tf_idf_1_corr.py - вариант для добавления скорректированных баннеров с окрестностями (пакетное переобучение)
##python tf_idf_1_corr.py
python tf_idf_2_3.py #здесь формируется словарь wrd_ctg_tf_idf (нужный, в том числе, и для динамического переобучения)
python tf_idf_4.py #порог = 0.98, СОЗДАЕТ словарь семантических ядер yuryz/tmp/bnrs_norm_sense

# --- III. ИТЕРАЦИОННАЯ дизамбигуация (ядра с MAX кластерами на каждой итерации остаются неизменными, а остальные ядра расширяются из трэша пословно) ---
python disamb.py #yuryz/tmp/bnrs_norm_sense => yuryz/tmp/bnrs_norm_sense_disamb

# --- IV. Построение семантического словаря Каталогии ---
python clast_size_distr_poli.py //home/catalogia/users/yuryz/tmp/bnrs_norm_sense_disamb #СОЗДАЕТ core_poli, core_one
python clast_size_distr.py //home/catalogia/users/yuryz/tmp/bnrs_norm_sense_disamb #СОЗДАЕТ clast_by_phrase (число строк = числу ядер)

python read_core_index.py >sem_core_word_list #ИСПОЛЬЗУЕТ core_one для добавления размера кластера (clast_size_distr_poli.py) и clast_by_phrase (clast_size_distr.py)
