#!/usr/bin/perl -w
#оптимизация фраз в категориях

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

#my $phr1 = "a[b/c/]d";
#my $phr2 = "[a/e][b/f/][c/][d/g][b/c/]";
#my $phr1 = "[a/][b/c/][d/]";
#my $phr2 = "[a/e][b/f/][c/][d/g][b/c]";

my $phr1 = "[a/][b/c]";
my $phr2 = "[a/b/c][b/][c/]";
#my $phr1 = "[a/][b/c]";
#my $phr2 = "[a/e/][b/c/d/]";

my @wds1 = phr_wrds($phr1);
print STDERR "@wds1\n";

my @wds2 = phr_wrds($phr2);
print STDERR "@wds2\n";
print STDERR "\n";

my $flag = 0;
if (@wds1 > @wds2) { #число "слов" во фразах
    $flag = 1;
    (@wds1, @wds2) = (@wds2, @wds1);
}

#построение индекса для ДЛИННОЙ фразы
my $ind2 = phr_ind(\@wds2);
my $het = $$ind2{"(+1)"} ? @{$$ind2{"(+1)"}} : 0; #число неоднородных "слов"
if (@wds2 - @wds1 > $het) {
    print STDERR "Вхождения нет\n";
    exit 1;
}

for (sort keys %{$ind2}) {
    print STDERR "$_\t@{$$ind2{$_}}\n"
}
print STDERR "\n";

my %plus_1;
for my $inds (@{$$ind2{"(+1)"}}) { #индексы для "(+1)" в длинной фразе
    my $i_num = $inds;
    $i_num =~ s/,.*$//; #2,1,2.3 - оставляем только номер слова (а дополнительные координаты убираем)
    $plus_1{$i_num} = 1;
}

my @comb; #комбинации всех вхождений слов короткой фразы в длинную
for my $i (0..$#wds1) { #препроцессинг КОРОТКОЙ фразы
    if ($wds1[$i] =~ /^\[/) { #анонимный атом
        my $a = $wds1[$i];
        $a =~ s/^\[//;
        $a =~ s/\]$//;
        my @a = split m{/}, $a;
        push @a, "(+1)" if $a =~ m{/$}; #признак неоднородности
        for my $j (0..$#a) { #анализ отдельных слов анонимного атома
            if ($$ind2{$a[$j]} && @{$$ind2{$a[$j]}} > 0) {
                @comb = cart_prod(\@comb, \@{$$ind2{$a[$j]}}); #номера слов длинной фразы, покрывающие слова короткой
                print STDERR "$a[$j] => @{$$ind2{$a[$j]}}\n";
            } else {
                print STDERR "*$a[$j] - вхождения нет\n";
                exit 1;
            }
        }
    } else { #обычное слово
        if ($$ind2{$wds1[$i]}) {
            @comb = cart_prod(\@comb, \@{$$ind2{$wds1[$i]}}); #номера слов длинной фразы, покрывающие слова короткой
            print STDERR "$wds1[$i] => @{$$ind2{$wds1[$i]}}\n";
        } else {
            print STDERR "*$wds1[$i] - вхождения нет\n";
            exit 1;
        }
    }
}
print STDERR "----------\n\n";


#=== ОБРАБОТКА КОРОТКОЙ ФРАЗЫ ===
for my $comb (@comb) {
    my @b = split / /, $comb; #номера слов длинной фразы, парных словам короткой
    my $k = 0; #текущий индекс массива @b
    my %w_num; #[номера слов длинной фразы], УЖЕ использованные для [слов короткой фразы]

    for my $i (0..$#wds1) { #определение признаков вхождения КОРОТКОЙ фразы
        if ($wds1[$i] =~ /^\[/) { #анонимный атом
            my $a = $wds1[$i];
            $a =~ s/^\[//;
            $a =~ s/\]$//;
            my @a = split m{/}, $a;
            push @a, "(+1)" if $a =~ m{/$}; #признак неоднородности

            my $f_num = 0; #[номер слова длинной фразы], использованный для [первого слова из атома короткой фразы]
            my $flag = 0;
            my @w_num;

            for my $j (0..$#a) { #анализ отдельных слов анонимного атома
                my $a_num = $b[$k];
                $a_num =~ s/,.*$//; #2,1,2.3 - оставляем только номер слова (а дополнительные координаты убираем)

                if ($a[$j] ne "(+1)") {
                    if ($f_num == 0) {
                        $f_num = $a_num;
                    } elsif ($f_num != $a_num) {
                        unless ($plus_1{$f_num} && $plus_1{$a_num}) {
                            $flag = 1;
                            last;
                        }
                    }
                }

                if ($w_num{$a_num}) { #[номер слова длинной фразы] уже встречался раньше
                    $flag = 1;
                    last;
                } else {
                    push @w_num, $a_num;
                }
                print "$a[$j]:".($i+1).",".($j+1)." => $b[$k++]\n";
            }
            if ($flag == 1) {
                print "Вхождения нет!\n";
                last;
            }
            #-------------------------
            $w_num{$_} = 1 for @w_num;
            #-------------------------
        } else { #обычное слово
            my $w_num = $b[$k];
            $w_num =~ s/,.*$//; #2,1,2.3 - оставляем только номер слова (а дополнительные координаты убираем)
            if ($w_num{$w_num}) { #[номер слова длинной фразы] уже встречался раньше 
                print "Вхождения нет!\n";
                last;
            } else {
                #------------------
                $w_num{$w_num} = 1;
                #------------------
            }
            print "$wds1[$i]:".($i+1)." => $b[$k++]\n";
        }
    }
    print "--\n";
}


#--- построение индекса фразы ---
sub phr_ind {
    my ($wds) = @_;

    my %ind; #хеш массивов
    for my $i (0..$#{$wds}) {
        if ($$wds[$i] =~ /^\[/) { #анонимный атом
            my $a = $$wds[$i];
            $a =~ s/^\[//;
            $a =~ s/\]$//;
            my @a = split m{/}, $a;
            push @a, "(+1)" if $a =~ m{/$}; #признак неоднородности
            for my $j (0..$#a) {
                push @{$ind{$a[$j]}}, ($i+1).",".($j+1);
            }
        } else {
            push @{$ind{$$wds[$i]}}, $i+1;
        }
    }

    return \%ind;
}





=z
while (<STDIN>) { #/opt/broadmatching/dicts/caddphr_web_ru
    chomp;

    my ($ctg, $phr_lst) = split /\t/; #категория, список фраз (comma-delimited)
    my @phr_lst = phr_opt($ctg, $phr_lst); #оптимизациия фраз в категории

    print "$ctg\t".join(",", @phr_lst)."\n";
}
=cut


#--- оптимизациия фраз в категории ---
sub phr_opt {
    my ($ctg, $phr_lst) = @_;

    my @phrs = split /,/, $phr_lst;
    for (@phrs) { #чистка
        s/^ +//;
        s/ +$//;
        s/  +/ /g;
    }

    my $flag = 1;
    for my $i (0..$#phrs) {
        next if $phrs[$i] =~ /^\*/; #фраза $phrs[$i] уже включена в какую-то фразу
        my @wrdsI = phr_wrds($phrs[$i]); #получение списка "слов" фразы
        for my $j (0..$#phrs) {
            next if $i == $j;
            next if $phrs[$j] =~ /^\*/; #фраза $phrs[$j] уже включена в какую-то фразу
            my @wrdsJ = phr_wrds($phrs[$j]);

            #-----------------------------------------------------
            next unless nec_cond(\@wrdsJ, \@wrdsI); #проверка необходимого условия вхождения $phrs[$j] в $phrs[$i]
            #-----------------------------------------------------

            if ($flag == 1) {
                $flag = 0;
                print STDERR "\n*КАТЕГОРИЯ: '$ctg'\n\n"; #категория
            }
            print STDERR "$i\t$phrs[$i]\n";
            print STDERR "$j\t$phrs[$j]\n";
            print STDERR "--\n";

            $phrs[$j] = "*$phrs[$j]";
        }
    }

    my @tmp;
    for (@phrs) { #фильтр более мелких подфраз
        push @tmp, $_ unless /^\*/;
    }
 
    my @phrs_num = split(/,/, $phr_lst); #исходное число фраз
    if ($flag == 0) { #были удаления фраз
        print STDERR "ЧИСЛО ФРАЗ: ДО=", @phrs_num+0, ", ПОСЛЕ=", @tmp+0, "\n";
    }

    return @tmp;
}


# --- необходимое условие вхождения одной фразы в другую ---
sub nec_cond {
    my ($a, $b) = @_; #списки "слов" (массивы) сравниваемых фраз

    my @a = del_com($a, $b); #удаление из @$a элементов, общих с @$b
    my @b = del_com($b, $a);

    @a = ("") unless @a;
    @b = ("") unless @b;

    my %hash; #отображение "слов" фразы @a в "слова" фразы @b
    for my $i (0..$#a) {
        my $key = $i + 1;
        for my $j (0..$#b) {
            if (wrds_incl($a[$i], $b[$j])) { #"слово" $a[$i] входит в слово $b[$j]
                my $value = $j + 1;
                push @{$hash{$key}}, $value;
            }
        }
    }
    return 0 if scalar keys %hash < @a; #"слова" @b не покрывают @a

    my @num_comb;
    for (sort keys %hash) { #####
        @num_comb = cart_prod(\@num_comb, \@{$hash{$_}}); #номера слов @b, ВОЗМОЖНО покрывающие @a
    }

    my $hom = 0; #число однородных атомов
    my %n;
    for my $nums (@num_comb) {
        my @n = split / /, $nums;
        %n = ();
        $n{$_}++ for @n; #распознанные РАЗНЫЕ номера
        next if scalar keys %n < @a; #ДАННАЯ комбинация "слов" @b не покрывают @a

        $hom = 0; #число однородных атомов среди "слов" @b, не участвующих в покрытии
        for my $i (0..$#b) {
            my $key = $i + 1;
            next if $n{$key};
            $hom++ unless $b[$i] =~ m{\/\]};
        }
        last if $hom == 0;
    }
    return 0 if scalar keys %n < @a; #"слова" фразы @b не покрывают фразу @a
    return 0 if $hom; #однородные атомы @b не позволяют выполнить покрытие @a

    return 1;
}


#--- проверка вхождения "слова" $a в слово $b ---
sub wrds_incl {
    my ($a, $b) = @_; #"слова" из разных фраз

    my @a = get_wrds($a);
    my @b = get_wrds($b);

    @a = ("") unless @a;
    @b = ("") unless @b;

    my %h;
    $h{$_} = 1 for @b;
    for (@a) {
        return 0 unless $h{$_};
    }
    return 1;
}


#--- получение списка слов атома ---
sub get_wrds {
    my ($a) = @_;

    $a =~ s/^\[//;
    $a =~ s/\]$//;
    $a =~ s/^ +//;
    $a =~ s/ +$//;
    my @a = split m{/}, $a;
    push @a, "" if $a =~ m{/$};

    return @a;
}


#--- удаление из массива @a элементов, общих с @b (с учетом количества) ---
sub del_com {
    my ($a, $b) = @_;

    my %h;
    $h{$_}++ for @$b;

    my @a;
    for (@$a) {
        unless ($h{$_}) {
            push @a, $_;
        } else {
            $h{$_}--;
            delete $h{$_} if $h{$_} == 0;
        }
    }

    return @a;
}


#--- генерация полного списка простых фраз ---
sub wrds_comb {
    my ($wrds) = @_; #список "слов" фразы

    my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
    for my $wrd (@$wrds) {
        my @tmp;
        if ($wrd =~ /^\[/) { #атом
            $wrd =~ s/^\[//;
            $wrd =~ s/\]$//;
            $wrd =~ s/^ +//;
            $wrd =~ s/ +$//;
            @tmp = split m{/}, $wrd;
            push @tmp, "" if $wrd =~ m{/$};
        } else { #не атом
            push @tmp, $wrd;
        }
        @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
    }

    for my $wrds_comb (@wrds_comb) {
        $wrds_comb =~ s/^ +//;
        $wrds_comb =~ s/ +$//;
        $wrds_comb =~ s/  +/ /g;

        $wrds_comb = join(" ", sort (phr_wrds($wrds_comb)));
    }

    return @wrds_comb;
}


#--- получение списка "слов" фразы ---
sub phr_wrds {
    my ($phr) = @_;

    #проверка и исправление синтаксиса
    if ($phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
        $phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
        $phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

        $phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
        $phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
    }
    $phr =~ s{\\}{\/}g if $phr =~ m{\\};

    return phr_parse($phr); #список "слов" фразы
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b, $DEL) = @_;
    $DEL = " " unless $DEL; #разделитель "слов"

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a$DEL$_" : $_ for @$b;
        }
    }

    return @prod;
}
