#!/usr/bin/perl -w
#пересечение атомов

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Project;
use Utils::Sys qw(print_log print_err get_file_lock release_file_lock handle_errors);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

my $CAT_TEMP_DIR = $ENV{CAT_TEMP_DIR}; #в родительском скрипте dup_detect.sh

handle_errors;
get_file_lock() or do {
    print_err("WARN: found already running script, do exit");
    exit(0);
};

my %natoms; #именованные атомы (хеш массивов)
open F, "$CAT_TEMP_DIR/named_atoms"; #результаты phr_ctgs_expand1.pl
while (<F>) {
    chomp;
    my ($atom, $num) = split /\t/; #атом, количество_элементов
    my @phl = atom_named_exp($atom);
    $natoms{"[$atom]"} = \@phl;

    #$proj->clog("$atom\t".(@phl+0), 'green'); #####
}

my @keys = sort { @{$natoms{$a}} <=> @{$natoms{$b}} || $a cmp $b} keys %natoms; #по возрастанию длин списка фраз
for my $i (0..$#keys-1) {
    my $keyI = $keys[$i];
    $keyI =~ s/^\[//;
    $keyI =~ s/\]$//;
    my %h = map { $_ => 1 } @{$natoms{$keys[$i]}}; #анонимный хеш
    for my $j ($i+1..$#keys) {
        my $keyJ = $keys[$j];
        $keyJ =~ s/^\[//;
        $keyJ =~ s/\]$//;
        for (@{$natoms{$keys[$j]}}) {
            if ($h{$_}) {
                #print "$keys[$i]\t$keys[$j]\t$_\n"; #атом1, атом2, общая фраза
                #print "$keys[$j]\t$keys[$i]\t$_\n";
                print "$keyI\t$keyJ\t$_\n"; #атом1, атом2, общая фраза
                print "$keyJ\t$keyI\t$_\n";
            }
        }
    }
}

=z
for (@keys) {
    print "$_\t", @{$natoms{$_}}+0, "\n";
}
=cut

print_err("atoms_cross.pl_OK");


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b) = @_;

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a $_" : $_ for @$b;
        }
    }

    return @prod;
}


#--- развертка именованного атома ---
sub atom_named_exp {
    my ($atom) = @_;

    my @phl = atom_raw_phrases($atom);
    if (@phl) {
        my @atom_phrs;
        for my $phr (@phl) {
            my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы

            my @wrds = phr_parse($phr); #слова фразы
            for my $wrd (@wrds) {
                my @tmp;
                if ($wrd =~ /^\[/) { #атом
                    $wrd =~ s/^\[//;
                    $wrd =~ s/\]$//;
                    $wrd =~ s/^ +//;
                    $wrd =~ s/ +$//;
                    for (split m{/}, $wrd) {
                        push @tmp, $_;
                    }
                    push @tmp, "" if $wrd =~ m{/$};
                } else { #не атом
                    push @tmp, $wrd;
                }
                @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
            }

            for (@wrds_comb) {
                s/^ +//;
                s/ +$//;
                s/  +/ /g;
            }
            push @atom_phrs, @wrds_comb;
        }
        return @atom_phrs;
    } else {
        return ($atom);
    }
}


#--- "сырые" фразы атома ---
sub atom_raw_phrases {
    my ($atom) = @_;

    my @phrases = ();                                                                                                                                                                                           
    my $category = $atom;                                                                                                                                                                  
    $category =~ s/^hier\./\./; #иерархический атом
    my @bfs_queue = ($category);                                                                                                                                                                                
    while (@bfs_queue) {                                                                                                                                                                                        
        my $root_category = shift(@bfs_queue);                                                                                                                                                                  
        push(@phrases, $proj->get_language('ru')->get_category_raw_phrases($root_category));                                                                                                                    
        push(@bfs_queue, $_) for $proj->categs_tree->get_minicateg_children($root_category);                                                                                                                    
    }
    return @phrases;
}
