#!/usr/bin/perl -w
#печать фраз из категорий с разверткой атомов - этап 1

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Project;
use Utils::Sys qw(print_log print_err get_file_lock release_file_lock handle_errors);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

my $CAT_TEMP_DIR = $ENV{CAT_TEMP_DIR}; #в родительском скрипте dup_detect.sh

handle_errors;
get_file_lock() or do {
    print_err("WARN: found already running script, do exit");
    exit(0);
};

my %natoms; #именованные атомы

while (<STDIN>) { #phrs_catalogia
    chomp;

    my ($ctg_phr, $id, $num) = split /\t/; #фраза, ID категории, номер фразы в категории

    #проверка и исправление синтаксиса
    if ($ctg_phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $ctg_phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
        $ctg_phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
        $ctg_phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

        $ctg_phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
        $ctg_phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
    }
    $ctg_phr =~ s{\\}{\/}g if $ctg_phr =~ m{\\};

    my @wrds = phr_parse($ctg_phr); # массив слов и словосочетаний фразы

    my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
    for my $wrd (@wrds) {
        my @tmp;
        if ($wrd =~ /^\[/) { #атом
            $wrd =~ s/^\[//;
            $wrd =~ s/\]$//;
            $wrd =~ s/^ +//;
            $wrd =~ s/ +$//;
            for (split m{/}, $wrd) {
                s/^ +//;
                s/ +$//;
                if (/^(hier)?\./) { #именованный атом
                    if ($natoms{$_}) {
                        push @tmp, "[$_]";
                    } else {
                        my @phl = atom_named_exp($_);
                        if (@phl > 0) {
                            push @tmp, "[$_]";
                            $natoms{$_} = @phl+0;
                        } else {
                            push @tmp, $_; #не атом
                        }
                    }
                } else { #не атом
                    push @tmp, $_;
                }
            }
            push @tmp, "" if $wrd =~ m{/$};
        } else { #не атом
            push @tmp, $wrd;
        }
        @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
    }

    for my $wrds_comb (@wrds_comb) {
        $wrds_comb =~ s/^ +//;
        $wrds_comb =~ s/ +$//;
        $wrds_comb =~ s/  +/ /g;

        if ($ARGV[0] =~ /^(norm|snorm)$/) {
            my @wrds = phr_parse($wrds_comb); # массив слов и словосочетаний фразы
            my @tmp;
            for my $wrd (@wrds) {
                my $tmp;
                unless ($wrd =~ /^(\[|\<)/) { #НЕ атом и НЕ би/мультиворд
                    if ($ARGV[0] eq "norm") {
                        $tmp = $proj->phrase($wrd)->norm_phr;
                    } else {
                        $tmp = $proj->phrase($wrd)->snorm_phr;
                    }
                } else {
                    $tmp = $wrd;
                }
                push @tmp, $tmp if $tmp;
            }
            $wrds_comb = join(" ", @tmp);
        }

        print "$wrds_comb\t$id\t$num\n"; #<фраза>, <ID категории>, номер фразы в категории
    }
}

open F, ">$CAT_TEMP_DIR/named_atoms";
print F "$_\t$natoms{$_}\n" for sort keys %natoms;

print_err("phr_ctgs_expand1.pl_OK");


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b) = @_;

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a $_" : $_ for @$b;
        }
    }

    return @prod;
}


#--- развертка именованного атома ---
sub atom_named_exp {
    my ($atom) = @_;

    my @phl = atom_raw_phrases($atom);
    if (@phl) {
        my @atom_phrs;
        for my $phr (@phl) {
            my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы

            my @wrds = phr_parse($phr); #слова фразы
            for my $wrd (@wrds) {
                my @tmp;
                if ($wrd =~ /^\[/) { #атом
                    $wrd =~ s/^\[//;
                    $wrd =~ s/\]$//;
                    $wrd =~ s/^ +//;
                    $wrd =~ s/ +$//;
                    for (split m{/}, $wrd) {
                        push @tmp, $_;
                    }
                    push @tmp, "" if $wrd =~ m{/$};
                } else { #не атом
                    push @tmp, $wrd;
                }
                @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
            }

            for (@wrds_comb) {
                s/^ +//;
                s/ +$//;
                s/  +/ /g;
            }
            push @atom_phrs, @wrds_comb;
        }
        return @atom_phrs;
    } else {
        return ($atom);
    }
}


#--- "сырые" фразы атома ---
sub atom_raw_phrases {
    my ($atom) = @_;

    my @phrases = ();                                                                                                                                                                                           
    my $category = $atom;                                                                                                                                                                  
    $category =~ s/^hier\./\./; #иерархический атом
    my @bfs_queue = ($category);                                                                                                                                                                                
    while (@bfs_queue) {                                                                                                                                                                                        
        my $root_category = shift(@bfs_queue);                                                                                                                                                                  
        push(@phrases, $proj->get_language('ru')->get_category_raw_phrases($root_category));                                                                                                                    
        push(@bfs_queue, $_) for $proj->categs_tree->get_minicateg_children($root_category);                                                                                                                    
    }
    return @phrases;
}
