#!/usr/bin/perl -w
#построение лексической сигнатуры фразы

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Project;
use Utils::Sys qw(print_log print_err get_file_lock release_file_lock handle_errors);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

my $CAT_TEMP_DIR = $ENV{CAT_TEMP_DIR}; #в родительском скрипте dup_detect.sh

handle_errors;
get_file_lock() or do {
    print_err("WARN: found already running script, do exit");
    exit(0);
};

my %natoms; #именованные атомы (хеш хешей)
open F, "$CAT_TEMP_DIR/named_atoms"; #результаты phr_ctgs_expand1.pl
while (<F>) {
    chomp;
    my ($atom, $num) = split /\t/; #атом, количество_элементов
    my @phl = atom_named_exp($atom);
    for (@phl) { #фразы атомов
        $natoms{$_}{$atom} = 1;
    }

    #$proj->clog("$atom\t".(@phl+0), 'green'); #####
}

while (my $rec = <STDIN>) { #phrs_ctgs_dup.dir (результаты phr_ctgs_expand1.pl)
    chomp $rec;

    my ($phr, $ctg, $num) = split /\t/, $rec; #<фраза>, <ID категории>, номер фразы в категории 
    my @wds = phr_parse($phr); #слова фразы
    my $sign = sprintf("%02d", @wds+0); #лексическая сигнатура

    my @sign;
    for my $i (0..$#wds) {
        next if $wds[$i] =~ /^\[/; #атомы в сигнатуру не входят
        next if $natoms{$wds[$i]}; #слова, входящие в атомы, в сигнатуру не входят
        push @sign, $wds[$i];
    }

    my @tmp = map { lc($_) } @sign;
    @sign = sort @tmp; # *** добавляем неупорядоченность
    $sign .= " ".join(" ", @sign) if @sign;

    print "$sign\t$rec\n";
}

print_err("words_in_atom.pl_OK");


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b) = @_;

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a $_" : $_ for @$b;
        }
    }

    return @prod;
}


#--- развертка именованного атома ---
sub atom_named_exp {
    my ($atom) = @_;

    my @phl = atom_raw_phrases($atom);
    if (@phl) {
        my @atom_phrs;
        for my $phr (@phl) {
            my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы

            my @wrds = phr_parse($phr); #слова фразы
            for my $wrd (@wrds) {
                my @tmp;
                if ($wrd =~ /^\[/) { #атом
                    $wrd =~ s/^\[//;
                    $wrd =~ s/\]$//;
                    $wrd =~ s/^ +//;
                    $wrd =~ s/ +$//;
                    for (split m{/}, $wrd) {
                        push @tmp, $_;
                    }
                    push @tmp, "" if $wrd =~ m{/$};
                } else { #не атом
                    push @tmp, $wrd;
                }
                @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
            }

            for (@wrds_comb) {
                s/^ +//;
                s/ +$//;
                s/  +/ /g;
            }
            push @atom_phrs, @wrds_comb;
        }
        return @atom_phrs;
    } else {
        return ($atom);
    }
}


#--- "сырые" фразы атома ---
sub atom_raw_phrases {
    my ($atom) = @_;

    my @phrases = ();                                                                                                                                                                                           
    my $category = $atom;                                                                                                                                                                  
    $category =~ s/^hier\./\./; #иерархический атом
    my @bfs_queue = ($category);                                                                                                                                                                                
    while (@bfs_queue) {                                                                                                                                                                                        
        my $root_category = shift(@bfs_queue);                                                                                                                                                                  
        push(@phrases, $proj->get_language('ru')->get_category_raw_phrases($root_category));                                                                                                                    
        push(@bfs_queue, $_) for $proj->categs_tree->get_minicateg_children($root_category);                                                                                                                    
    }
    return @phrases;
}
