#!/usr/bin/perl -w
#определение % омонимов в кампании

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

my $MIN_CAMP = 50; #минимальный размер кампании
my $MIN_HOM = 5; #минимальный процент омонимов в кампании

my %categs;
my $freq_total;
my $freq_hom;
my $camp_prev = "";
my $frac;
while (<STDIN>) { #/home/yuryz/scripts/data/bnrs_10kk.camp
    chomp;

    my @f = split /\t/;
    my $id = $f[0];
    my $camp = $f[1];
    my $text = "$f[3] $f[4]";
    my $url = $f[8];
    my $categ = substr($f[20], 6); #mctgs=
    $categ = "NO_CATEGS" unless $categ;

    if ($camp_prev ne $camp) { #разные кампании
        #printf ("$camp_prev\t$freq_total\t$freq_hom\t%.2f\n", 100 * $freq_hom / $freq_total) if %categs;
        if (%categs) {
            $frac = sprintf ("%.2f", 100 * $freq_hom / $freq_total);
            printf "$camp_prev\t$freq_total\t$freq_hom\t$frac\n" if $freq_total >= $MIN_CAMP && $frac >= $MIN_HOM;
        }

        %categs = ();
        $freq_total = 1;
        $freq_hom = $categ =~ m{/} ? 1 : 0;
        $camp_prev = $camp;
    }

    $categs{$categ}++; #частота категории
    unless ($categ =~ /NO_CATEGS/) {
       $freq_total++;
       $freq_hom++ if $categ =~ m{/};
    }
}
$frac = sprintf ("%.2f", 100 * $freq_hom / $freq_total);
printf "$camp_prev\t$freq_total\t$freq_hom\t$frac\n" if $freq_total >= $MIN_CAMP && $frac >= $MIN_HOM;
