#!/usr/bin/perl -w
#собственно классификация

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

my %dict; #словарь для классификации
open F, "bayes.dict";
my $ctg;
while (<F>) {
    chomp;
    my @a = split /\t/;
    if ($a[0]) { #класс (категория)
        $ctg = $a[0];
        $dict{$ctg}{DOC} = $a[1]; #число документов $a[1] в классе $ctg
        $dict{$ctg}{SUM} = $a[2]; #сумма частот всех слов  $a[2]в классе $ctg
    } else {
        $dict{$ctg}{$a[1]} = $a[2]; #частота $a[2] слова $a[1] в классе $ctg
    }
}

=z
for my $ctg (sort keys %dict) {
    print "$ctg\t", $dict{$ctg}{DOC}, "\t", $dict{$ctg}{SUM}, "\n";
    for my $key (sort keys %{$dict{$ctg}}) {
        print "\t$key\t", $dict{$ctg}{$key}, "\n" unless $key =~ /^(DOC|SUM)$/;
    }
}

print scalar keys %{$dict{"15\" мониторы"}}, "\n";
print scalar keys %{$dict{"21\" мониторы"}}, "\n";
print scalar keys {( %{$dict{"15\" мониторы"}}, %{$dict{"21\" мониторы"}} )}, "\n";
=cut


#===============================
open F, "bayes.train.words.add.1";
my %wrds;
while (<F>) {
    chomp;
    my @f = split /\t/; #0 - категория, 1 - слова
    $wrds{$f[1]} = $f[0];
}
#===============================


my @ctgs; #категории баннера
my $D; #число документов в обучающей выборке
my %v; #слияние хешей категорий
my $V; #кол-во уникальных слов во всех документах обучающей выборки

my $prev_ctgs = "";
while (<STDIN>) { #bayes.test.words (test1, test2, ...)
    chomp;
    my ($ctgs, $wrds, $id, $title, $body) = split /\t/;
    if ($prev_ctgs ne $ctgs) {
        $prev_ctgs = $ctgs;

        @ctgs = (); #категории баннера
        map {push @ctgs, $_ if $dict{$_}} split m{/}, $ctgs; #удаляем категории, которых нет в обучающей выборке

        $D = 0; #число документов в обучающей выборке
        %v = (); #слияние хешей категорий
        for (@ctgs) {
            #print "$_\t", $dict{$_}{DOC}, "\t", $dict{$_}{SUM}, "\n";
            $D += $dict{$_}{DOC};
            %v = (%v, %{$dict{$_}});
        }
        $V = (scalar keys %v) - 2; #кол-во уникальных слов во всех документах обучающей выборки (-2 из-за DOC и SUM)
    }

#-----------------------
    my @scores;
    my $score_max = -INFINITY;
    my $ind_max = -1;
    #print "$ctgs\t$id\t$title\t$body\t$wrds\n";
    my @wrds = split / /, $wrds; #слова баннера

    for my $i (0..$#ctgs) {
        my $scores = log( $dict{$ctgs[$i]}{DOC} / $D );
        for (@wrds) {
            my $W = 1; #частота слова со сглаживанием Лапласа
            $W += $dict{$ctgs[$i]}{$_} if $dict{$ctgs[$i]}{$_}; #частота слова в словаре
            $scores += log( $W / ($V + $dict{$ctgs[$i]}{SUM}) );
        }
        $scores[$i] = sprintf("%.3f", $scores);

        #print "\t$ctgs[$i]\t", sprintf("%.3f", $scores), "\n";
        if ($score_max < $scores) {
            $score_max = $scores;
            $ind_max = $i;
        }
    }
    
    if ($scores[0] < $scores[1]) {
        print "$ctgs\t$id\t$title\t$body\t$wrds\n";
    }

=z
    if ($wrds{$wrds} ne $ctgs[$ind_max]) {
        #print "<$wrds{$wrds}>\t[$ctgs[$ind_max]]\t$ctgs\t$id\t$title\t$body\t$wrds\n";
        #print "<$wrds{$wrds}>\t[$ctgs[$ind_max]]\t$wrds\n";
        print "$wrds{$wrds}\t$wrds\n";
    }
=cut
}
