#!/usr/bin/perl -w
#снятие омонимии с помощью контекста кампаний и лэндингов

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

#use FindBin;
#use lib "$FindBin::Bin/../lib";
#use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/wlib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

my $MIN_CAMP = 200; #min число баннеров в кампании

my @camp;
my %camp;
my $camp_prev = "";
while (<STDIN>) { #/home/yuryz/scripts/data/bnrs_10kk.camp
    chomp;

    my @f = split /\t/;
    my $id = $f[0];
    my $camp = $f[1];
    my $text = "$f[3] $f[4]";
    my $url = $f[8];
    my $categ = substr($f[20], 6); #mctgs=
    $categ = "NO_CATEGS" unless $categ;

    my $lang = $f[21];
    next unless $lang eq "lang=ru";

    if ($camp_prev ne $camp) { #новая кампания
        if (@camp >= $MIN_CAMP) {
            my $ctg_freq = (sort { $camp{$b} <=>  $camp{$a} || $a cmp $b } keys %camp)[0]; #самая частотная категория
            my @ctg_freq = ancestors_add([$ctg_freq]); #анонимный массив
            print "***$camp\t", @camp+0, "\t$ctg_freq[0]\n";
            for my $i (0..$#camp) {
                my ($id, $text, $categ, $url) = split /\t/, $camp[$i];
                my @ctgs = split m{/}, $categ;
                if (@ctgs > 1) { #омонимия
                    print "\t$id\t$text\t$categ";

                    my %ctgs; #частотный словарь категорий

                    my @cat_land = $proj->page($url)->get_minicategs; #категоризация по landing page
                    if (@cat_land) {
                        $ctgs{$_}++ for @cat_land;
                        #my @ancest_land = ancestors_add(\@cat_land);
                        #my $cat_land = join "\t", @ancest_land;
                        #my $cat_land = join "/", @cat_land;
                        #print "\t[$cat_land]";
                    }

                    my $bnr = $proj->bf->get_banner_by_id($id);
                    my $h = $bnr->get_intent; #ссылка на хеш с ключом intent
                    #print "\t{$$h{intent}}";

                    my $phr = $proj->phrase($$h{intent});

                    my @cat_int = $phr->get_minicategs; #категоризация по intent
                    if (@cat_int) {
                        $ctgs{$_}++ for @cat_int;
                        #my @ancest_int = ancestors_add(\@cat_int);
                        #my $cat_int = join "\t", @ancest_int;
                        #print "\t<$cat_int>";
                    }

                    my @cat_snip = $phr->get_minicategs_snippets; #категоризация по intent
                    if (@cat_snip) {
                        $ctgs{$_}++ for @cat_snip;
                        #my @ancest_int = ancestors_add(\@cat_snip);
                        #my $cat_snip = join "\t", @ancest_int;
                        #print "\t($cat_snip)";
                    }

                    my @a = $bnr->parse; #массив: (brand, model)
                    my $brand = $a[0] ? $a[0] : "";
                    $brand .= $brand && $a[1] ? " $a[1]" : $a[1] ? $a[1] : "";
                    #print "\t%$brand%";
                    my $phrb = $proj->phrase($brand);
                    my @cat_brand = $phrb->get_minicategs_snippets; #категоризация по brand+model
                    if (@cat_brand) {
                        $ctgs{$_}++ for @cat_brand;
                        #my @ancest_int = ancestors_add(\@cat_brand);
                        #my $cat_brand = join "\t", @ancest_int;
                        #print "\t#$cat_brand#";
                    }

=z
                    my $phrt = $proj->phrase($f[3]); #title
                    my @cat_tit = $phrt->get_minicategs_snippets; #категоризация по title
                    if (@cat_tit) {
                        $ctgs{$_}++ for @cat_tit;
                        #my @ancest_tit = ancestors_add(\@cat_tit);
                        #my $cat_tit = join "\t", @ancest_tit;
                        #print "\t!$cat_tit!";
                    }
=cut


                    print "\n";

                    for (keys %ctgs) { #частотный словарь категорий
                        print "\t[ $_\t$ctgs{$_} ]\n";
                    }

                    my @ancestors = ancestors_add(\@ctgs);
                    print "\t*", $camp{$ctg_freq}, "\t$ctg_freq\n"; #самая частая категория в кампании
                    for my $i (0..$#ctgs) {
                        #print "\t$camp{$ctgs[$i]}\t$ancestors[$i]\n";
                        print "\t$camp{$ctgs[$i]}\t$ctgs[$i]\n";
                    }
                    print "\n";
                }
            }
        }

        @camp = ();
        %camp = ();
        $camp_prev = $camp;
    }

    my @ctgs = split m{/}, $categ;
    for my $ctg (@ctgs) {
        $camp{$ctg}++;
    }
    push @camp, join("\t", $id, $text, $categ, $url);
}
print @camp+0, "\n";


#--- добавление предков для категорий ---
sub ancestors_add {
    my ($categs) = @_;

    my @categs_ancestors;
    for my $categ (@$categs) {
        my @ancestors; #все предки категории
        my $ancestor = $categ;
        while ($ancestor = $proj->categs_tree->get_minicateg_parent($ancestor)) {
            push @ancestors, $ancestor;
        }
        push @categs_ancestors, join("/", reverse @ancestors)."/$categ";
    }

    return @categs_ancestors;
}
