#!/usr/bin/perl -w
#снятие омонимии с помощью лэндингов

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
#use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/wlib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

my ($total, $homonym, $disamb) = (0, 0, 0);
while (<STDIN>) { #/home/yuryz/scripts/data/bnrs_10kk.camp
    chomp;
    $total++; #####

    my @f = split /\t/;
    next if $f[21] ne "lang=ru";

    my $categ = substr($f[20], 6); #mctgs=
    next unless $categ && $categ =~ m{/};

    #ОМОНИМИЯ
    $homonym++; #####
    my @ctgs = split m{/}, $categ;
    my $id = $f[0];
    my $camp = $f[1];
    my $text = "$f[3] $f[4]";
    my $url = $f[8];

    my %ctgs; #частотный словарь категорий

    $ctgs{$_}++ for $proj->page($url)->get_minicategs; #категоризация по landing page

    my $bnr = $proj->bf->get_banner_by_id($id);
    next unless $bnr;

    my $h = $bnr->get_intent; #ссылка на хеш с ключом intent
    my $phr = $proj->phrase($$h{intent});
    if ($phr) {
        $ctgs{$_}++ for $phr->get_minicategs; #категоризация по intent
        $ctgs{$_}++ for $phr->get_minicategs_snippets; #категоризация по intent
    }

    my ($brand, $model) = $bnr->parse; #массив: (brand, model)
    my $br_mod;
    if ($brand && $model) {
        $br_mod = "$brand $model";
    } elsif ($brand) {
        $br_mod = $brand;
    } elsif ($model) {
        $br_mod = $model;
    } else {
        $br_mod = "";
    }
    $phr = $proj->phrase($br_mod);
    if ($phr) {
        $ctgs{$_}++ for $phr->get_minicategs_snippets; #категоризация по brand+model
    }

    #for my $ctg (sort { $ctgs{$b} <=> $ctgs{$a} || $a cmp $b } keys %ctgs) {
    #    print "\t$ctg\t$ctgs{$ctg}\n";
    #}

    #СНЯТИЕ ОМОНИМИИ
    my $ctg_hom; #значение омонима
    my $ctg_max = -1; #частота омонима 
    my $child; #для отношения "родитель-ребенок"
    for my $i (0..$#ctgs) {
        if ($ctgs{$ctgs[$i]}) {
            if ($ctg_max < $ctgs{$ctgs[$i]}) {
                $ctg_hom = $ctgs[$i];
                $ctg_max = $ctgs{$ctgs[$i]};
            } elsif ($ctg_max == $ctgs{$ctgs[$i]}) { #должен быть ровно один max
                $ctg_hom = "";
                $ctg_max = -1;
                last;
            }
        }

        if ($i < $#ctgs) {
            my $parentI = $proj->categs_tree->get_minicateg_parent($ctgs[$i]);
            for my $j ($i+1..$#ctgs) {
                $child = $ctgs[$i] if $parentI eq $ctgs[$j];
                my $parentJ = $proj->categs_tree->get_minicateg_parent($ctgs[$j]);
                $child = $ctgs[$j] if $parentJ eq $ctgs[$i];
            }
        }
    }

    if ($child || $ctg_hom) {
        $disamb++; #####
        print "$id\t$text\t$categ\t";
        if ($child) {
            print "$child";
        } else {
            print "$ctg_hom";
        }

        #печать категории с max частотой
        my @tmp = sort { $ctgs{$b} <=> $ctgs{$a} || $a cmp $b } keys %ctgs;
        my $ctg_tmp;
        $ctg_tmp = $tmp[0] if @tmp && (@tmp == 1 || $ctgs{$tmp[0]} ne $ctgs{$tmp[1]});
        print "\t[ $ctg_tmp ]" if $ctg_tmp;

        printf "\t%.2f%%\t%.2f%%", 100 * $homonym / $total, 100 * $disamb / $homonym;
        print "\n";
    }
}


#--- добавление предков для категорий ---
sub ancestors_add {
    my ($categs) = @_;

    my @categs_ancestors;
    for my $categ (@$categs) {
        my @ancestors; #все предки категории
        my $ancestor = $categ;
        while ($ancestor = $proj->categs_tree->get_minicateg_parent($ancestor)) {
            push @ancestors, $ancestor;
        }
        push @categs_ancestors, join("/", reverse @ancestors)."/$categ";
    }

    return @categs_ancestors;
}
