#!/usr/bin/perl -w
#создание частотных словарей категорий на основе текстов баннеров

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

my %dict;
my $dic_sum = 0;
while (<STDIN>) { #z1pre
    chomp;
    my $bnr_text = bnr_text_clean($_);
    map { $dict{$_}++, $dic_sum++ } split / /, $bnr_text;
}

for (sort { $dict{$b} <=> $dict{$a} || $a cmp $b } keys %dict) {
    $dict{$_} /= $dic_sum;
    printf "$_\t%.3f\n", $dict{$_};
}


#--- очистка строки текста ---
sub bnr_text_clean {
    my ($text) = @_;

    my $valid_chars = qr/0-9a-zа-яё \-/; #допустимые символы

    $text =~ s/_[^ ]+/ /g; #служебные слова: __delivery_pattern, _percent, ...
    
    $text = lc($text);
    $text =~ s/(?<=[\[\/])\.[$valid_chars]+?(?=[\]\/])/ /g; #атомы
    $text =~ s/-[$valid_chars]+?(?=( |[^$valid_chars]|$))/ /g; #минус слова
    $text =~ s/[^$valid_chars]/ /g;

    $text =~ s/ [^ ] / /g; #однобуквенные

    $text =~ s/^ +//;
    $text =~ s/ +$//;
    $text =~ s/ +/ /g;
    
    return $text;
}
