#!/usr/bin/perl -w
#выбор категорий с неснятой омонимией

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

my %h;
while (<STDIN>) { #../data/disamb_pairs
    chomp;
    s/^ +//;
    /^(\d+) (.+)$/; #частота + омонимичные категории\tвыбранная_катгория
    my ($freq, $cat) = ($1, $2);
    my ($cat1, $cat2) = split /\t/, $cat;
    $h{$cat1}{$cat2} = $freq;
}

my $sum = 0;
for my $cat1 (sort keys %h) {
    if (scalar keys %{$h{$cat1}} == 1) { #однозначные решения (disamb_uniq)
    #if (scalar keys %{$h{$cat1}} > 1) { #неоднозначные решения (disamb_ambiq)
        for my $cat2 (sort keys %{$h{$cat1}}) {
            print "$cat1\t$cat2\t$h{$cat1}{$cat2}\n";
            $sum += $h{$cat1}{$cat2};
        }
    }
}

print STDERR "$sum\n";
