#!/usr/bin/perl -w
use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({
    load_dicts   => 1,
    load_minicategs_light => 1, 
});

my $bad_categs = qr/(курьерские услуги|поиск работы|Вакансия|продвижение сайтов|Подарки, сувениры, цветы|Услуги базаров, рынков|Серверы|Реклама в интернете|Сырье, концентраты|NCAP Автомобили малого класса|Скидочные купоны)/;

#my $bid = '1007925978'; #ID баннера для тестирования
#my $bid = '1005177284'; #ID баннера для тестирования
#my $bid = '1005177343'; #ID баннера для тестирования
my $bid = '2918712142'; #ID баннера для тестирования
my $banner = $proj->bf->get_banner_by_id($bid);

my $campaign = $banner->campaign_obj;
for my $bnr (sort {$a->id cmp $b->id} @{$campaign->bnl}) { #баннеры кампании
    my $bnr_info = join("\t", $bnr->id, $bnr->banner_text_phrase->text, $bnr->url);

    my @categs = $proj->phrase($bnr->banner_text_phrase->text)->get_minicategs; #категоризация по тексту баннера
    if (@categs) {
        my @categs_tmp;
        for my $categ (@categs) {
            unless ($categ =~ /${bad_categs}$/) {
                push @categs_tmp, $categ;
            } else {
=z
                my @categs_land = $proj->page($bnr->url)->get_minicategs; #категоризация по landing page
                if (@categs_land) {
                    my @categs_land_tmp;
                    for my $categ_land (@categs_land) {
                        unless ($categ_land =~ /${bad_categs}$/) {
                            push @categs_land_tmp, $categ_land;
                        }
                    }
                    @categs_land = @categs_land_tmp;
                }
                push @categs_tmp, @categs_land if @categs_land;
=cut
            }
        }
        @categs = @categs_tmp;
    } else {
=z
        @categs = $proj->page($bnr->url)->get_minicategs; #категоризация по landing page
        if (@categs) {
            my @categs_tmp;
            for my $categ (@categs) {
                unless ($categ =~ /${bad_categs}$/) {
                    push @categs_tmp, $categ;
                }
            }
            @categs = @categs_tmp;
        }
=cut
    }

    unless (@categs) {
        #@categs = $bnr->get_categs_neighbors; #категоризация по ближайшим соседям
    }

    categ_ancestors($bnr, \@categs);
}


#печать категорий с предками
sub categ_ancestors {
    my ($bnr, $categs) = @_;

    my $bnr_info = join("\t", $bnr->id, $bnr->banner_text_phrase->text, $bnr->url);

    if (@$categs) {
        for my $categ (@$categs) {
            my @ancestors_tree; #все предки
            my $tmp_categ = $categ;
            while ($tmp_categ = $proj->categs_tree->get_minicateg_parent($tmp_categ)) {
                push @ancestors_tree, $tmp_categ;
            }
            print $bnr_info."\t".join("/", reverse @ancestors_tree)."/$categ\n";
        }
    } else {
        print "$bnr_info\tNO_CATEGS\n";
    }

=z
    my $phrase_list = $bnr->phl; #список фраз баннера
    for my $phrase (@$phrase_list) {
        $phrase =~ s/ -[^ ].+$//; #минус-слова
        $phrase =~ s/\+//g;
        print "\t$phrase\n";
    }
=cut
}
