#!/usr/bin/perl -w
use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({
    load_dicts   => 1,
    load_minicategs_light => 1, 
});


my $phr = $proj->phrase('Однажды, в студеную зимнюю пору, я из лесу вышел - был сильный мороз!');

# нормализация фразы
print "$phr => ".$phr->norm_phr."\n\n";

# род-число-падеж
for my $word ( $phr->words ){
    my $h = $proj->phrase( $word )->get_gender_number_case( add_posp => 1 );
    print Dumper ( [ $word, $h ] );
}

exit;

if (0 ){
while (<>){
    chomp;
    my $bnr = $proj->bf->text2banner($_);
    print Dumper ( ['ID: '.$bnr->id, 
                    'URL: '.$bnr->url, 
                    'TEXT: '.$bnr->banner_text_phrase->text ] ); 
}
}

if (0) {
my $phl = $proj->phrase_list([]);
my $phl_random_banners = $phl->random_banners(20);
#print Dumper ( [ $phl_random_banners->perl_array ] );

#my $phl_random_banners_texts = $phl_random_banners->banners2banners_texts;
#print Dumper ( [ $phl_random_banners_texts->perl_array ] );

#my @res = map { $_->text." => ".join("/", $_->get_minicategs) } @$phl_random_banners_texts;
#print Dumper ( \@res );

#my $phl_random_banners_urls = $phl_random_banners->banners2urls;
#print Dumper ( [ $phl_random_banners_urls->perl_array ] );

my $banner_list = $phl_random_banners->banners2bnl;
for my $bnr (@$banner_list){
    print Dumper ( ['ID: '.$bnr->id, 
                    'URL: '.$bnr->url, 
                    'TEXT: '.$bnr->banner_text_phrase->text, 
                    'CATEGS: '.join("/", $bnr->banner_text_phrase->get_minicategs) || "NO CATEGS", 
                    'URL_CATEGS: '.join("/", $proj->page( $bnr->url )->get_minicategs) || "NO_CATEGS" ] );
}
}

