#!/usr/bin/python
# -*- coding: utf-8 -*-

#преобразование блоков к виду, удобному для векторизации

import yt.wrapper as yt

def join_be_url(key, recs): #добавляем поля из banners_extended
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #'//home/catalogia/banners_extended'
            bid = rec['bid']
            title = rec['title']
            body = rec['body']
            url = rec['href']
        elif bid != 0: # '//home/catalogia/users/yuryz/etalon/block_sens_num'
            del rec['domain']
            rec['bnr'] = { "title": title, "body": body, "url": url }

            yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/etalon/block_sens_num'
    tab2 = '//tmp/yuryz/block_sens_num'

    yt.run_sort(tab1, tab2, sort_by=['bid'])

    tab3 = '//home/catalogia/banners_extended'
    tab4 = '//home/catalogia/users/yuryz/multik/block4vector'

    yt.run_reduce(join_be_url, [tab3, tab2], tab4, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))


if __name__ == '__main__':
    main()
