#!/usr/bin/python
# -*- coding: utf-8 -*-

#отбор "свежих" баннеров из banners_extended

import sys
import re
import yt.wrapper as yt


def bnrs_fresh_select(rec): #отбор "свежих" баннеров
    if rec['timestamp'][:4] >= '2016': #отбираем за последние 3 года
        yield { "bid": rec['bid'], "timestamp": -int(rec['timestamp'][:4]) }


def del_dup(key, recs): #удаление дублей
    yield recs.next()


def get_bnrs_info(key, recs): #получение информации о баннерах из banners_extended
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #'//tmp/yuryz/bnrs_fresh_'
            bid = rec['bid']
        elif bid != 0: #'//home/catalogia/banners_extended'
            if rec['title'] and rec['title'] != '' and rec['body'] and rec['body'] != '' and rec['href'] and rec['href'] != '' and rec['mctgs'] and rec['mctgs'] != '':
                ctgs = rec['mctgs'].split('/')
                if len(ctgs) <= 3: #ограничение MAX числа категорий в мультилебле
                    mctgs = '/'.join(sorted(ctgs))
                    yield { "bid": key['bid'], "title": rec['title'], "body": rec['body'], "url": rec['href'], "mctgs": mctgs }


def ctgs_freq_dict(key, recs): #cоставление частотного словаря категорий
    cnt = 0
    for rec in recs:
        cnt += 1
    yield { "mctgs": key['mctgs'], "freq": -cnt }


def main():
    # --- 1. Отбор "свежих" баннеров ---
    tab1 = '//home/catalogia/banner-history-recategorized'
    tab2 = '//tmp/yuryz/bnrs_fresh'

    #yt.run_map(bnrs_fresh_select, tab1, tab2, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab2, sort_by=['bid', 'timestamp'])

    tab2_ = '//tmp/yuryz/bnrs_fresh_' #без дублей bid

    #yt.run_reduce(del_dup, tab2, tab2_, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab2_, sort_by='bid')

    # --- 2. Получение информации о баннерах из banners_extended ---
    tab3 = '//home/catalogia/banners_extended'
    tab4 = '//tmp/yuryz/bnrs_fresh_text'

    #yt.run_reduce(get_bnrs_info, [tab2_, tab3], tab4, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab4, sort_by=['title', 'body', 'url', 'mctgs'])

    tab5 = '//home/catalogia/users/yuryz/multik/bnrs_fresh_text'

    #yt.run_reduce(del_dup, tab4, tab5, reduce_by = ['title', 'body', 'url'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab5, sort_by=['mctgs', 'bid', 'title', 'body'])

    # --- 3. Составление частотного словаря категорий ---
    tab6 = '//home/catalogia/users/yuryz/multik/ctgs_freq_dict'

    #yt.run_reduce(ctgs_freq_dict, tab5, tab6, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab6, sort_by=['freq', 'mctgs'])

    # --- 4. Формирование списка категорий при заданном минимальном числе баннеров в категории ---
    #"""
    freq_min_multi = 50 #минимальное число баннеров в мультилейбле
    freq_min_mono = 50 #минимальное число баннеров в монолейбле
    for rec in yt.read_table(tab6, raw=False):
        if -rec['freq'] < min(freq_min_mono, freq_min_multi):
            break

        mctgs = rec['mctgs'].split('/')
        if len(mctgs) > 1: #мультилейбл
            if -rec['freq'] >= freq_min_multi:
                print rec['mctgs'] + '\t' + str(-rec['freq']) #список категорий для загрузки в YT
        else: #монолейбл
            if -rec['freq'] >= freq_min_mono:
                print rec['mctgs'] + '\t' + str(-rec['freq']) #список категорий для загрузки в YT
    #"""


if __name__ == '__main__':
    main()
