#!/usr/bin/python
# -*- coding: utf-8 -*-

#синхронизация категорий "свежих" баннеров со списком отобранных категорий (bnrs_fresh_sel.py)
#и сэмплирование выборки нужного размера

import random
import sys
import re
import yt.wrapper as yt


def ctgs_sync(key, recs): #синхронизация категорий баннеров
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #'//tmp/yuryz/categories' (bnrs_fresh_sel.py и readme.txt)
            mctgs = rec['mctgs']
        elif mctgs != '': #'//home/catalogia/users/yuryz/multik/bnrs_fresh_text'
            yield rec


class bnrs_sel(object): #сэмплирование баннеров
    def __init__(self, prob):
        self.prob = prob

    def __call__(self, rec):
        if random.uniform(0, self.prob) < 1: #вероятность = 1 / prob
            yield rec


def ctgs_freq_dict(key, recs): #частотный словарь категорий сэмпла
    cnt = 0
    for rec in recs:
        cnt += 1
    yield { "mctgs": key['mctgs'], "freq": cnt }


MIN_FREQ = 3 #минимально допустимое число баннеров в категориях сэмпла

class bnrs_add4sample(object): #добавление баннеров для категорий, не вошедших в сэмпл в достаточном количестве
    def __init__(self, sampl_ctgs2freq):
        self.sampl_ctgs2freq = sampl_ctgs2freq

    def __call__(self, key, recs):
        mctgs = ''
        bnrs_add = []
        cnt = 0
        for rec in recs:
            table_index = rec.pop('@table_index')
            if table_index == 0: #'//tmp/yuryz/categories' (bnrs_fresh_sel.py и readme.txt)
                mctgs = rec['mctgs']
                freq_sample = self.sampl_ctgs2freq.get(mctgs, 0)
                if freq_sample < MIN_FREQ:
                    while len(bnrs_add) < MIN_FREQ - freq_sample:
                        num = random.randrange(1, rec['freq'] + 1)
                        if num not in bnrs_add:
                            bnrs_add.append(num)
            elif mctgs != '': #'//home/catalogia/users/yuryz/multik/bnrs_fresh_text'
                cnt += 1
                if cnt in bnrs_add:
                    yield rec


class bnrs_conv(object): #окончательный формат
    def __init__(self, ctgs2ids):
        self.ctgs2ids = ctgs2ids

    def __call__(self, rec):
        ctg_names = rec['mctgs'].split('/')
        ids = []
        for ctg_name in ctg_names:
            if ctg_name in self.ctgs2ids:
                ids.append(str(self.ctgs2ids[ctg_name]))
            else:
                ids.append(ctg_name)
        ctg_ids = ','.join(ids)

        yield { "shard": 0, "BannerID": rec['bid'], "Title": rec['title'], "Body": rec['body'], "AutoCategoryIDs": ctg_ids, "Url": rec['url'] }


def main():
    #--- 1. Синхронизация категорий баннеров ---
    tab1 = '//tmp/yuryz/categories'
    tab2 = '//home/catalogia/users/yuryz/multik/bnrs_fresh_text'
    tab3 = '//home/catalogia/users/yuryz/multik/bnrs_fresh_text_ctgs'

    #yt.run_reduce(ctgs_sync, [tab1, tab2], tab3, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab3, sort_by=['bid'])

    #--- 2. Сэмплирование обучающей выборки ---
    BNRS4TRAIN = 1000000.0 #число баннеров для обучения
    prob = yt.row_count(tab3) / BNRS4TRAIN #вероятность выбора баннеров

    tab4 = '//tmp/yuryz/bnrs4train'

    #if yt.exists(tab4):
    #    yt.remove(tab4)
    #yt.run_map(bnrs_sel(prob), tab3, tab4)

    #--- 3. Добавление баннеров для категорий, не вошедших в сэмпл в достаточном количестве ---
    tab5 = '//tmp/yuryz/sample_ctgs_freq_dict'

    #yt.run_sort(tab4, sort_by=['mctgs'])
    #yt.run_reduce(ctgs_freq_dict, tab4, tab5, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))

    sampl_ctgs2freq = {} #частотный словарь категорий сэмпла
    for rec in yt.read_table(tab5, raw=False): #
        sampl_ctgs2freq[rec['mctgs']] = rec['freq']

    #yt.run_reduce(bnrs_add4sample(sampl_ctgs2freq), [tab1, tab2], yt.TablePath(tab4, append=True), reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))

    #--- 4. Окончательное форматирование ---
    ctgs2ids = {} #маппинг CategoryName в CategoryID
    for rec in yt.read_table('//home/catalogia/categories_tree', raw=False):
        ctgs2ids[rec['Category']] = rec['DirectID']

    tab6 = '//tmp/yuryz/TrainTextShard_upd' #имя выбрано из-за корректировки категорий (см. shard_prepare.py)

    yt.run_map(bnrs_conv(ctgs2ids), tab4, tab6)


if __name__ == '__main__':
    main()
