#!/usr/bin/python
# -*- coding: utf-8 -*-

#выбор баннеров для проверки точности категоризации пустых баннеров по соседям в РК и по соседям в доменах

import random
import yt.wrapper as yt


class bnrs_sel(object):
    def __init__(self, prob):
        self.prob = prob

    def __call__(self, rec):
        if random.uniform(0, self.prob) < 1: #вероятность = 1 / prob
            yield rec


def main():
    t1 = '//home/catalogia/users/yuryz/multik/ctgs_by_neighbors_yes'
    t2 = '//tmp/yuryz/verif'

    BNRS4TEST = 1000.0 #число баннеров для ghjdthrb
    prob = yt.row_count(t1) / BNRS4TEST #вероятность выбора баннеров

    yt.run_map(bnrs_sel(prob), t1, t2)
    #yt.run_sort(t2, sort_by=['bid'])


if __name__ == '__main__':
    main()
