#!/usr/bin/python
# -*- coding: utf-8 -*-

#выбор баннеров из banners_extended, не имющих категорий

import sys
import re
import yt.wrapper as yt


def bnrs_fresh_select(rec): #отбор "свежих" баннеров
    if rec['timestamp'][:4] >= '2016': #отбираем за последние 4 года
        yield { "bid": rec['bid'], "timestamp": -int(rec['timestamp'][:4]) }


def del_dup(key, recs): #удаление дублей
    yield recs.next()


def get_bnrs_info(key, recs): #получение информации о баннерах из banners_extended
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #'//tmp/yuryz/bnrs_fresh_'
            bid = rec['bid']
        elif bid != 0: #'//home/catalogia/banners_extended'
            if rec['mctgs'] == '':
                yield { "bid": key['bid'], "title": rec['title'], "body": rec['body'], "url": rec['href'], "mctgs": rec['mctgs'] }


def bnrs_test_select(rec): #выбор тестовых баннеров
    if rec['title'] == '' and rec['body'] == '':
        yield { "bid": rec['bid'], "title": rec['title'], "snippet": rec['body'], "url": rec['url'], "categories": rec['mctgs'], "true_categories": rec['mctgs'] }


class bnrs_sel_prob(object):
    def __init__(self, prob):
        self.prob = prob

    def __call__(self, rec):
        if rec['title'] == '' and rec['body'] == '':
            if random.uniform(0, self.prob) < 1: #вероятность = 1 / prob
                yield { "bid": rec['bid'], "title": rec['title'], "snippet": rec['body'], "url": rec['url'], "categories": rec['mctgs'], "true_categories": rec['mctgs'] }


def main():
    # --- 1. Отбор "свежих" баннеров ---
    tab1 = '//home/catalogia/banner-history-recategorized'
    tab2 = '//tmp/yuryz/bnrs_fresh'

    #yt.run_map(bnrs_fresh_select, tab1, tab2, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab2, sort_by=['bid', 'timestamp'])

    tab2_ = '//tmp/yuryz/bnrs_fresh_' #без дублей bid

    #yt.run_reduce(del_dup, tab2, tab2_, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab2_, sort_by='bid')

    # --- 2. Получение информации о баннерах из banners_extended ---
    tab3 = '//home/catalogia/banners_extended'
    tab4 = '//tmp/yuryz/bnrs_fresh_text'

    #yt.run_reduce(get_bnrs_info, [tab2_, tab3], tab4, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab4, sort_by=['title', 'body', 'url', 'mctgs'])

    tab5 = '//home/catalogia/users/yuryz/multik/bnrs_not_ctgs'

    #yt.run_reduce(del_dup, tab4, tab5, reduce_by = ['title', 'body', 'url'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab5, sort_by=['title', 'body', 'url', 'bid'])

    # --- 3. Построение тестовой выборки ---
    tab6 = '//tmp/yuryz/bnrs_not_ctgs_test'

    ##yt.run_map(bnrs_test_select, tab5, tab6, format=yt.YsonFormat(control_attributes_mode="row_fields"))

    BNRS4TEST = 50000.0 #число баннеров для тестирования
    prob = yt.row_count(tab6) / BNRS4TEST #вероятность выбора баннеров

    yt.run_map(bnrs_sel_prob(prob), tab5, tab6, format=yt.YsonFormat(control_attributes_mode="row_fields"))



if __name__ == '__main__':
    main()
