#!/usr/bin/python
# -*- coding: utf-8 -*-

#построение частотного словаря несовпавших категорий

import random
import sys
import re
import yt.wrapper as yt


class ctgs_no_match(object): #отбор несовпавших категорий Каталогии и Мультика
    def __init__(self, ids2ctgs):
        self.ids2ctgs = ids2ctgs

    def __call__(self, rec):
        if rec['labels'] == 'NO_LABELS':
            return

        true_ctg_names = []
        for bnr in rec['true_categories']:
            true_ctg_names.append(bnr['name'])
        true_ctg_names.sort()
        true_names = '/'.join(true_ctg_names)

        rec['labels'] = rec['labels_freq'] #===MAX частота===
        ctg_names = []
        ids = rec['labels'].split(',')
        for id in ids:
            if id in self.ids2ctgs:
                ctg_names.append(self.ids2ctgs[id])
            else:
                ctg_names.append(id)
        ctg_names.sort()
        names = '/'.join(ctg_names)

        if true_names != names: # категория НЕ угадана Мультиком
            yield { "Catalogia": true_names, "Multik": names }


def ctgs_freq_dict(key, recs): #cоставление частотного словаря категорий
    cnt = 0
    for rec in recs:
        cnt += 1
    yield { "Catalogia": key['Catalogia'], "Multik": key['Multik'], "freq": -cnt }


def main():
    ids2ctgs = {} #маппинг CategoryID в CategoryName
    for rec in yt.read_table('//home/catalogia/categories_tree', raw=False): #актуальные категории
        ids2ctgs[str(rec['DirectID'])] = rec['Category']

    tab1 = '//home/catalogia/users/yuryz/multik/test_with_categs'
    tab2 = '//tmp/yuryz/ctgs_no_match'

    #yt.run_map(ctgs_no_match(ids2ctgs), tab1, tab2, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab2, sort_by=['Catalogia', 'Multik'])

    tab3 = '//home/catalogia/users/yuryz/multik/ctgs_no_match'

    #yt.run_reduce(ctgs_freq_dict, tab2, tab3, reduce_by = ['Catalogia', 'Multik'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['freq', 'Catalogia', 'Multik'])


if __name__ == '__main__':
    main()
