#!/usr/bin/python
# -*- coding: utf-8 -*-

#отбор мультикатегорий и построение частотного словаря соседей

import random
import sys
import re
import yt.wrapper as yt


def sel_multi_ctg(rec): #отбор мультикатегорий в результатах категоризации
    for neighbor in rec['neighbors']:
        if len(neighbor['categories']) > 1:
            yield rec
            break


def main():
    tab = '//home/catalogia/users/yuryz/multik/test_with_categs'
    tab_multi = '//home/catalogia/users/yuryz/multik/multi_categs'

    #yt.run_map(sel_multi_ctg, tab, tab_multi)

    total = yt.row_count(tab)
    total_corr = 0
    total_right = 0
    total_one = 0
    total_multi = 0

    match = 0
    match_corr = 0
    match_right = 0
    match_one = 0
    match_multi = 0

    for rec in yt.read_table(tab, raw=False):
        #--- частотный словарь категорий соседей ---
        ctg_freq = {}
        for neighbor in rec['neighbors']:
            for ctg in neighbor['categories']:
                ctg_freq[ctg] = ctg_freq.get(ctg, 0) + 1

        #print rec['bid']
        #elems = sorted(ctg_freq.items(), key = lambda x: x[1], reverse=True)
        #freq_max = elems[0][1] #max частота
        elems = sorted(ctg_freq.items(), key = lambda x: x[1], reverse=True)
        freq_max = elems[0][1] #max частота
        ctgs = []
        #for elem in sorted(ctg_freq.items(), key = lambda x: x[1], reverse=True): #пары <категория, частота>
        for elem in elems: #пары <категория, частота>
            if elem[1] == freq_max:
                ctgs.append(elem[0])
        labels = ','.join(sorted(ctgs))
        #print '\t' + labels
        rec['labels'] = labels

        #--- частотный словарь категорий соседей ---
        true_ctg_ids = []
        for bnr in rec['true_categories']:
            true_ctg_ids.append(bnr['id'])
        true_ctg_ids.sort()
        true_ids = ','.join(true_ctg_ids)

        ctg_ids = []
        for bnr in rec['categories']:
            ctg_ids.append(bnr['id'])
        ctg_ids.sort()
        ids = ','.join(ctg_ids)

        if rec['labels'] == true_ids: # категория угадана Мультиком
            match += 1

        if true_ids != ids: #исправленные категории в тестовой выборке
            total_corr += 1
            if rec['labels'] == true_ids: #исправленная категория угадана Мультиком
                match_corr += 1
        else: #НЕисправленные категории в тестовой выборке
            total_right += 1
            if rec['labels'] == true_ids: #НЕисправленная категория угадана Мультиком
                match_right += 1

        labels = rec['labels'].split(',')
        if len(true_ctg_ids) == 1: #угадывание одиночных категорий
            total_one += 1
            if rec['labels'] == true_ids: #исправленная категория угадана Мультиком
            ##if true_ids in labels: #исправленная категория угадана Мультиком (НЕЧЕТКОЕ СОВПАДЕНИЕ)
                match_one += 1
        else: #угадывание мультикатегорий
            total_multi += 1
            if rec['labels'] == true_ids: #исправленная категория угадана Мультиком
                match_multi += 1
            """
            cnt = 0
            for id in true_ctg_ids:
                if id in labels: #исправленная категория угадана Мультиком (НЕЧЕТКОЕ СОВПАДЕНИЕ)
                    cnt += 1
            if cnt == len(true_ctg_ids): #нашлись ВСЕ правильные категории
                match_multi += 1
            """

    print 'Все категории:', match, total, '%.3f' % (float(match) / total)
    print 'Исправленные категории:', match_corr, total_corr, '%.3f' % (float(match_corr) / total_corr)
    print 'НЕисправленные категории:', match_right, total_right, '%.3f' % (float(match_right) / total_right)
    print 'Одиночные категории:', match_one, total_one, '%.3f' % (float(match_one) / total_one)
    print 'Мультилейблы:', match_multi, total_multi, '%.3f' % (float(match_multi) / total_multi)


if __name__ == '__main__':
    main()
