#!/usr/bin/python
# -*- coding: utf-8 -*-

#оценка качества категоризации Каталогии

import random
import sys
import re
import yt.wrapper as yt


def main():
    #tab = '//home/catalogia/users/yuryz/multik/test_with_categs'
    tab = '//home/catalogia/users/yuryz/multik/big_test_danila'

    total = yt.row_count(tab)
    total_corr = 0
    total_right = 0
    total_one = 0
    total_multi = 0

    match = 0
    match_corr = 0
    match_right = 0
    match_one = 0
    match_multi = 0

    for rec in yt.read_table(tab, raw=False):
        true_ctg_ids = []
        for bnr in rec['true_categories']:
            true_ctg_ids.append(bnr['id'])
        true_ctg_ids.sort()
        true_ids = ','.join(true_ctg_ids)

        ctg_ids = []
        for bnr in rec['categories']:
            ctg_ids.append(bnr['id'])
        ctg_ids.sort()
        ids = ','.join(ctg_ids)

        if ids == true_ids: # категория угадана Каталогией
            match += 1

        if true_ids != ids: #исправленные категории в тестовой выборке
            total_corr += 1
            if ids == true_ids: #исправленная категория угадана Каталогией
                match_corr += 1
        else: #НЕисправленные категории в тестовой выборке
            total_right += 1
            if ids == true_ids: #НЕисправленная категория угадана Каталогией
                match_right += 1

        labels = rec['labels'].split(',')
        if len(true_ctg_ids) == 1: #угадывание одиночных категорий
            total_one += 1
            if ids == true_ids: #исправленная категория угадана Каталогией
                match_one += 1
        else: #угадывание мультикатегорий
            total_multi += 1
            if ids == true_ids: #исправленная категория угадана Каталогией
                match_multi += 1

    print 'Все категории:', match, total, '%.3f' % (float(match) / total)
    print 'Исправленные категории:', match_corr, total_corr, '%.3f' % (float(match_corr) / total_corr)
    print 'НЕисправленные категории:', match_right, total_right, '%.3f' % (float(match_right) / total_right)
    print 'Одиночные категории:', match_one, total_one, '%.3f' % (float(match_one) / total_one)
    print 'Мультилейблы:', match_multi, total_multi, '%.3f' % (float(match_multi) / total_multi)


if __name__ == '__main__':
    main()
