#!/usr/bin/perl -w
#упрощенное тестирование полного вхождения одной фразы в другую

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my $ctg_prev = "";
my $num_prev = -1;
my %phr = ();
while (my $s1 = <STDIN>) { #zdup
    print STDERR $s1;
    chomp $s1;

    my @a = split /\t/, $s1; #предпоследнее поле - номер фразы в категории, последнее поле - текст фразы
    my $ctg1 = join("\t", @a[0..$#a-2]);
    my $num1 = $a[$#a-1];
    my $phr1 = $a[$#a];

    my $s2 = <STDIN>;
    print STDERR $s2;
    chomp $s2;
    
    @a = split /\t/, $s2;
    my $ctg2 = join("\t", @a[0..$#a-2]);
    my $num2 = $a[$#a-1];
    my $phr2 = $a[$#a];

    my $s3 = <STDIN>; #разделитель пар
    print STDERR $s3;
    chomp $s3;

    %phr = () unless $ctg_prev eq $ctg1 && $num_prev == $num1;
    $ctg_prev = $ctg1;
    $num_prev = $num1;

    #my $flag = full_dup($phr1, $phr2); #фразы и списки минус-слов $phr1 и $phr2 полностью совпадают
    my $flag = dup_minus($phr1, $phr2); #фразы $phr1 и $phr2 полностью совпадают, а списки минус-слов $phr2 полностью входят в $phr1
    if ($flag > 0) {
        print "$s1\n";
        print "$s2\n";
        print "$s3\n";
    }
}


#--- проверка идентичности фраз ---
sub full_dup {
    my ($phr1, $phr2) = @_;

    #return 0 if $phr1 =~ /[\[\{]/;

    #$phr1 = lc($phr1);
    #$phr2 = lc($phr2);
    #return $phr1 eq $phr2;

#=z
    #$phr1 = lc($phr1);
    #$phr2 = lc($phr2);

    my @phr1 = sort split / /, $phr1;
    my @phr2 = sort split / /, $phr2;

    return join(" ", @phr1) eq join(" ", @phr2);
#=cut
}


#--- обработка минус-слов ---
sub dup_minus {
    my ($phr1, $phr2) = @_;

    return 0 unless $phr1 =~ / -[A-Za-zА-ЯЁа-яё]/; #в $phr1 нет минус-слов

    #$phr1 = lc($phr1);
    #$phr2 = lc($phr2);

    my @a = sort split / /, $phr1;
    #my @a = split / /, $phr1;
    my @phr1;
    for (@a) {
        push @phr1, $_ unless /^-/; #минус-слова
    }

    @a = sort split / /, $phr2;
    #@a = split / /, $phr2;
    my @phr2;
    for (@a) {
        push @phr2, $_ unless /^-/;
    }

    return join(" ", @phr1) eq join(" ", @phr2);
}


#--- тестирование полного вхождения фразы $phr2 во фразу $phr1 ---
sub phr_incl {
    my ($phr1, $phr2) = @_;

    if (scalar keys %phr == 0) {
        my @wrds1 = phr_wrds($phr1); #получение списка "слов" $phr1
        my @lst1 = wrds_comb(\@wrds1); #полный список простых фраз для $phr1
        #print "$_\n" for @lst1;
        $phr{$_} = 1 for @lst1;
    }

    my @wrds2 = phr_wrds($phr2);
    my @lst2 = wrds_comb(\@wrds2);
    #print "$_\n" for @lst2;
    for (@lst2) {
        return 0 unless $phr{$_};
    }
    return 1;
}


#--- генерация полного списка простых фраз ---
sub wrds_comb {
    my ($wrds) = @_; #список "слов" фразы

    my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
    for my $wrd (@$wrds) {
        my @tmp;
        if ($wrd =~ /^\[/) { #атом
            $wrd =~ s/^\[//;
            $wrd =~ s/\]$//;
            $wrd =~ s/^ +//;
            $wrd =~ s/ +$//;
            @tmp = split m{/}, $wrd;
            push @tmp, "" if $wrd =~ m{/$};
        } elsif ($wrd =~ /^-/) { #минус-слово
            next;
        } else { #не атом и не минус-слово
            push @tmp, $wrd;
        }
        @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
    }

    for my $wrds_comb (@wrds_comb) {
        $wrds_comb =~ s/^ +//;
        $wrds_comb =~ s/ +$//;
        $wrds_comb =~ s/  +/ /g;

        $wrds_comb = lc($wrds_comb);

        $wrds_comb = join(" ", sort (phr_wrds($wrds_comb)));
    }

    return @wrds_comb;
}

#########################################

#--- оптимизациия фраз в категории ---
sub phr_opt {
    my ($ctg, $phr_lst) = @_;

    my @phrs = split /,/, $phr_lst;
    for (@phrs) { #чистка
        s/^ +//;
        s/ +$//;
        s/  +/ /g;
    }

    my $flag = 1;
    for my $i (0..$#phrs) {
        next if $phrs[$i] =~ /^\*/; #фраза $phrs[$i] уже включена в какую-то фразу
        my @wrdsI = phr_wrds($phrs[$i]); #получение списка "слов" фразы
        for my $j (0..$#phrs) {
            next if $i == $j;
            next if $phrs[$j] =~ /^\*/; #фраза $phrs[$j] уже включена в какую-то фразу
            my @wrdsJ = phr_wrds($phrs[$j]);

            #-----------------------------------------------------
            next unless nec_cond(\@wrdsJ, \@wrdsI); #проверка необходимого условия вхождения $phrs[$j] в $phrs[$i]
            #-----------------------------------------------------

            if ($flag == 1) {
                $flag = 0;
                print STDERR "\n*КАТЕГОРИЯ: '$ctg'\n\n"; #категория
            }
            print STDERR "$i\t$phrs[$i]\n";
            print STDERR "$j\t$phrs[$j]\n";
            print STDERR "--\n";

            $phrs[$j] = "*$phrs[$j]";
        }
    }

    my @tmp;
    for (@phrs) { #фильтр более мелких подфраз
        push @tmp, $_ unless /^\*/;
    }
 
    my @phrs_num = split(/,/, $phr_lst); #исходное число фраз
    if ($flag == 0) { #были удаления фраз
        print STDERR "ЧИСЛО ФРАЗ: ДО=", @phrs_num+0, ", ПОСЛЕ=", @tmp+0, "\n";
    }

    return @tmp;
}


# --- необходимое условие вхождения одной фразы в другую ---
sub nec_cond {
    my ($a, $b) = @_; #списки "слов" (массивы) сравниваемых фраз

    my @a = del_com($a, $b); #удаление из @$a элементов, общих с @$b
    my @b = del_com($b, $a);

    @a = ("") unless @a;
    @b = ("") unless @b;

    my %hash; #отображение "слов" фразы @a в "слова" фразы @b
    for my $i (0..$#a) {
        my $key = $i + 1;
        for my $j (0..$#b) {
            if (wrds_incl($a[$i], $b[$j])) { #"слово" $a[$i] входит в слово $b[$j]
                my $value = $j + 1;
                push @{$hash{$key}}, $value;
            }
        }
    }
    return 0 if scalar keys %hash < @a; #"слова" @b не покрывают @a

    my @num_comb;
    for (sort keys %hash) { #####
        @num_comb = cart_prod(\@num_comb, \@{$hash{$_}}); #номера слов @b, ВОЗМОЖНО покрывающие @a
    }

    my $hom = 0; #число однородных атомов
    my %n;
    for my $nums (@num_comb) {
        my @n = split / /, $nums;
        %n = ();
        $n{$_}++ for @n; #распознанные РАЗНЫЕ номера
        next if scalar keys %n < @a; #ДАННАЯ комбинация "слов" @b не покрывают @a

        $hom = 0; #число однородных атомов среди "слов" @b, не участвующих в покрытии
        for my $i (0..$#b) {
            my $key = $i + 1;
            next if $n{$key};
            $hom++ unless $b[$i] =~ m{\/\]};
        }
        last if $hom == 0;
    }
    return 0 if scalar keys %n < @a; #"слова" фразы @b не покрывают фразу @a
    return 0 if $hom; #однородные атомы @b не позволяют выполнить покрытие @a

    return 1;
}


#--- проверка вхождения "слова" $a в слово $b ---
sub wrds_incl {
    my ($a, $b) = @_; #"слова" из разных фраз

    my @a = get_wrds($a);
    my @b = get_wrds($b);

    @a = ("") unless @a;
    @b = ("") unless @b;

    my %h;
    $h{$_} = 1 for @b;
    for (@a) {
        return 0 unless $h{$_};
    }
    return 1;
}


#--- получение списка слов атома ---
sub get_wrds {
    my ($a) = @_;

    $a =~ s/^\[//;
    $a =~ s/\]$//;
    $a =~ s/^ +//;
    $a =~ s/ +$//;
    my @a = split m{/}, $a;
    push @a, "" if $a =~ m{/$};

    return @a;
}


#--- удаление из массива @a элементов, общих с @b (с учетом количества) ---
sub del_com {
    my ($a, $b) = @_;

    my %h;
    $h{$_}++ for @$b;

    my @a;
    for (@$a) {
        unless ($h{$_}) {
            push @a, $_;
        } else {
            $h{$_}--;
            delete $h{$_} if $h{$_} == 0;
        }
    }

    return @a;
}


#--- генерация полного списка простых фраз ---
sub wrds_comb_src {
    my ($wrds) = @_; #список "слов" фразы

    my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
    for my $wrd (@$wrds) {
        my @tmp;
        if ($wrd =~ /^\[/) { #атом
            $wrd =~ s/^\[//;
            $wrd =~ s/\]$//;
            $wrd =~ s/^ +//;
            $wrd =~ s/ +$//;
            @tmp = split m{/}, $wrd;
            push @tmp, "" if $wrd =~ m{/$};
        } else { #не атом
            push @tmp, $wrd;
        }
        @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
    }

    for my $wrds_comb (@wrds_comb) {
        $wrds_comb =~ s/^ +//;
        $wrds_comb =~ s/ +$//;
        $wrds_comb =~ s/  +/ /g;

        $wrds_comb = join(" ", sort (phr_wrds($wrds_comb)));
    }

    return @wrds_comb;
}


#--- получение списка "слов" фразы ---
sub phr_wrds {
    my ($phr) = @_;

    #проверка и исправление синтаксиса
    if ($phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
        $phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
        $phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

        $phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
        $phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
    }
    $phr =~ s{\\}{\/}g if $phr =~ m{\\};

    return phr_parse($phr); #список "слов" фразы
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b, $DEL) = @_;
    $DEL = " " unless $DEL; #разделитель "слов"

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a$DEL$_" : $_ for @$b;
        }
    }

    return @prod;
}
