#!/usr/bin/perl -w
#дублирование фраз в категориях

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my $cnt = 0;
while (<STDIN>) { #~/arcadia/rt-research/broadmatching/dicts/caddphr_web_ru (/opt/broadmatching/dicts/caddphr_web_ru)
    chomp;

    my @a = split /\t/; #последнее поле - список фраз (comma-delimited)

    my $ctg = join("\t", @a[0..$#a-1]);
    my $phr_lst = $a[$#a];

    my @w = split //, $phr_lst;
    my $flag = 0;
    for my $i (0..$#w) {
        $flag = 1 if $w[$i] eq "{";
        $flag = 0 if $w[$i] eq "}";
        $w[$i] = "@" if $w[$i] eq "," && $flag == 1; #экранирование запятых внутри {}
    }
    $phr_lst = join "", @w;

    my @phr_lst = phrs_dupl($ctg, $phr_lst); #дублирование фраз в категориях
    $phr_lst = join(",", @phr_lst);
    $phr_lst =~ s/\@/,/g; #восстановление экранированных запятых
    print "$_,$phr_lst\n";
#$cnt++ if $ctg;;
#print STDERR "$cnt\n";
    #print "$phr_lst\n";
    #print "--\n";

=z
    $phr_lst = join(",", @phr_lst);
    $phr_lst =~ s/\@/,/g; #восстановление экранированных запятых
    if ($ctg) {
        print "$ctg\t$phr_lst\n";
    } else {
        print "$phr_lst\n";
    }
=cut
}


#--- дублирование фраз в категориях ---
sub phrs_dupl {
    my ($ctg, $phr_lst) = @_;

    my @phrs = ();
    @phrs = split /,/, $phr_lst if $phr_lst;

    my @a;
    for my $i (0..$#phrs) {
        if ($i % 2 == 0) {
            push @a, $phrs[$i];
        }
    }

    return @a;
}
