#!/usr/bin/perl -w
#перемешивание фраз в категориях

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

while (<STDIN>) { #~/arcadia/rt-research/broadmatching/dicts/caddphr_web_ru (/opt/broadmatching/dicts/caddphr_web_ru)
    chomp;

    my @a = split /\t/; #последнее поле - список фраз (comma-delimited)

    my $ctg = join("\t", @a[0..$#a-1]);
    my $phr_lst = $a[$#a];

    my @w = split //, $phr_lst;
    my $flag = 0;
    for my $i (0..$#w) {
        $flag = 1 if $w[$i] eq "{";
        $flag = 0 if $w[$i] eq "}";
        $w[$i] = "@" if $w[$i] eq "," && $flag == 1; #экранирование запятых внутри {}
    }
    $phr_lst = join "", @w;

    my @phr_lst = phrs_shuf($ctg, $phr_lst); #перемешивание фраз в категориях

    $phr_lst = join(",", @phr_lst);
    $phr_lst =~ s/\@/,/g; #восстановление экранированных запятых
    if ($ctg) {
        print "$ctg\t$phr_lst\n";
    } else {
        print "$phr_lst\n";
    }
}


#--- перемешивание фраз в категориях ---
sub phrs_shuf {
    my ($ctg, $phr_lst) = @_;

    my @phrs = ();
    @phrs = split /,/, $phr_lst if $phr_lst;

    my %dup;
    my @a;
    for my $i (0..$#phrs) {
        my $num = int(rand(@phrs+0)) + 1;
        redo if $dup{$num};
        $dup{$num} = 1;
        push @a, $phrs[$num-1];
    }

    return @a;
}
