#!/usr/bin/perl -w
# выбор товаров для пополнения Каталогии

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
#use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/wlib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


=z
my $phl = $proj->phrase_list(['https://market.yandex.ru/?clid=1955454&win=105'])->pages2goods;
for (@{$phl}) {
    print "$_\n";
}
=cut


while (<STDIN>) { #/home/yuryz/scripts/data/bnrs_10kk.camp
    chomp;

    my @f = split /\t/;
    next if $f[21] ne "lang=ru";

    my $categ = substr($f[20], 6); #mctgs=
    next unless $categ && $categ !~ m{/}; #оставляем НЕомонимы

    my $id = $f[0];
    my $camp = $f[1];
    my $text = "$f[3] $f[4]"; #баннер
    my $url = $f[8];

    my $bnr = $proj->bf->get_banner_by_id($id);
    next unless $bnr;

print "\t$text\n";
    my $phl = $proj->phrase_list([$url])->pages2goods;
    for (@{$phl}) {
        print "$_\n";
    }
}
