#!/usr/bin/perl -w
#поиск омонимичных фраз в категориях

use strict;
use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

#use FindBin;
#use lib "$FindBin::Bin/../lib";
#use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/wlib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

my $worker = Utils::Worker->new;
$worker->{verbose}    = 1;
$worker->{num_processes}    = 12;

$worker->{file_input}       = "/home/yuryz/scripts/phrs4ctgs/ctgs_full_list.txt";
$worker->{file_output}      = "/home/yuryz/scripts/phrs4ctgs/phrs4ctgs_homonym";

$worker->{process_line}     = sub {
    my ($line, $fh) = @_;
    chomp $line;

    my ($ind, $id, $id_parent, $ctg) = split /\t/, $line;

    my $ctg_phrs = $proj->phrase($ctg)->get_category_phrases; #список фраз категорий
    if (@$ctg_phrs) {
        for my $ctg_phr (@$ctg_phrs) {
            #проверка и исправление синтаксиса
            if ($ctg_phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $ctg_phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
                $ctg_phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
                $ctg_phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

                $ctg_phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
                $ctg_phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
            }
            $ctg_phr =~ s{\\}{\/}g if $ctg_phr =~ m{\\};

            my @wrds = phr_parse($ctg_phr); # массив слов и словосочетаний фразы
            my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
            for my $wrd (@wrds) {
                $wrd =~ s/^\[//; # для атомов
                $wrd =~ s/\]$//;
                my @tmp = split m{/}, $wrd;
                push @tmp, "" if $wrd =~ m{/$};
                @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
            }

            for my $wrds_comb (@wrds_comb) {
                unless ($wrds_comb =~ /((^\.| \.)|\{)/) { #пропускаем именованные атомы и вложенные категории
                    my $ctgs_lst = join "/", @{[$proj->phrase($wrds_comb)->get_minicategs]};
                    print $fh "$ctg\t$wrds_comb\t$ctgs_lst\n" if $ctgs_lst =~ m{/}; #омонимичные фразы
                }
            }
        }
    }
};

$worker->process_data;


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b) = @_;

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a $_" : $_ for @$b;
        }
    }

    return @prod;
}
