#!/usr/bin/perl -w
#обход направленного графа для поиска circulus vitiosus во фразах категорий

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;


my %graph; #граф для обхода (хеш массивов)
while (<STDIN>) { #phr_ctgs_graph
    chomp;
    my ($ctg_1, $ctg_2) = split /\t/;
    push @{$graph{$ctg_1}}, $ctg_2
}

for my $ctg_1 (sort keys %graph) { #печать связных цепочек графа
    my @chain = ($ctg_1); #необработанные цепочки
    while (my $chain = shift @chain) { #текущая цепочка для обработки выбирается из начала очереди
        my $queue_len = @chain+0; #текущая длина очереди
        my $last_elem = (split /\t/, $chain)[-1]; #последний элемент цепочки
        for my $ctg_2 (@{$graph{$last_elem}}) {
            unless ($chain =~ /(^|\t)$ctg_2(\t|$)/) {
                push @chain, "$chain\t$ctg_2"; #добавление новой цепочки в конец очереди
            } else {
                #print "CIRCULUS VITIOSUS: $chain\t{$ctg_2}\n"
                print "$chain\t{$ctg_2}\n"
            }
        }
        if ($queue_len == @chain) { #нет новых цепочек
            if (scalar (split /\t/, $chain) > 2) {
                #print "$chain\n";
            }
        }
    }
    #print "--\n"; #все цепочки для одной вершины графа обработаны
}
