#!/usr/bin/perl -w
#поиск нарушений синтаксиса фраз в категориях

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


while (<STDIN>) { #/home/yuryz/scripts/phrs4ctgs/ctgs_full_list.txt
    chomp;

    my ($ind, $id, $id_parent, $ctg) = split /\t/;
    #next if $ind ne "s0237"; #***ОТЛАДКА

    my $ctg_phrs = $proj->phrase($ctg)->get_category_phrases; #список фраз категорий
    if (@$ctg_phrs) {
        for my $ctg_phr (@$ctg_phrs) {
            #проверка и исправление синтаксиса
            if ($ctg_phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $ctg_phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
                #print "$ctg\t$ctg_phr\n"; # 1 err_space
                $ctg_phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
                $ctg_phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

                $ctg_phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
                $ctg_phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
            }
            $ctg_phr =~ s{\\}{\/}g if $ctg_phr =~ m{\\};

            #print "$ctg_phr\n";
            my @wrds = phr_parse($ctg_phr); # массив слов и словосочетаний фразы
            my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
            for my $wrd (@wrds) {
                if ($wrd =~ /\[/) { #атомы
                    unless ($wrd =~ m{/}) {
                        unless ($wrd =~ /^\[\.[^]]+\]$/) { #неименованные атомы
                            #print "$ctg\t$wrd\n"; # 2 err_atoms
                        }
                    } elsif ($wrd =~ m{[[/][^[/<. ]+ [^[/> ]+[/\]]}) { #пробел между '[/' и '/]' при отсутствии '< ... >'
                        print "$ctg\t$wrd\n"; # 3 err_multi_words
                    }
                } elsif ($wrd =~ /</) { #мультислова
                    unless ($wrd =~ m{ }) {
                        #print "$ctg\t$wrd\n"; # отсутствие пробела внутри '<...>' - это, возможно НЕ ошибка
                    }
                }
            }
        }
    }
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b) = @_;

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a $_" : $_ for @$b;
        }
    }

    return @prod;
}
