#!/usr/bin/perl -w
#поиск фраз в категориях, категоризуемых с ошибкой

use strict;
use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

#use FindBin;
#use lib "$FindBin::Bin/../lib";
#use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/wlib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1); 

my $worker = Utils::Worker->new;
$worker->{verbose}    = 1;
$worker->{num_processes}    = 12;

$worker->{file_input}       = "/home/yuryz/scripts/phrs4ctgs/phrs_ctgs_dup";
$worker->{file_output}      = "/home/yuryz/scripts/phrs4ctgs/phrs4ctgs_bad";

$worker->{process_line}     = sub {
    my ($line, $fh) = @_;
    chomp $line;

    my ($phr, $ctg) = split /\t/, $line;
    my $ctgs_lst = join "/", @{[$proj->phrase($phr)->get_minicategs]};
    print $fh "$ctg\t$phr\t$ctgs_lst\n" if !$ctgs_lst || $ctgs_lst !~ m{\Q$ctg\E}; #фразы, категоризуемые неправильно
};

$worker->process_data;


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b) = @_;

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a $_" : $_ for @$b;
        }
    }

    return @prod;
}

