#!/usr/bin/perl -w
#корректировка категорий caddphr_web_ru_src для бета-тестирования на основе задания

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


my %dict; #словарь для корректировки
open F, $ARGV[0];
while (<F>) {
    chomp;

    my ($ctg, $phr_lst) = split /\t/; #категория, список фраз (comma-delimited)
    $dict{$ctg} = $phr_lst;
}

my %ctgs_corr; #категории для корректировки
while (<STDIN>) { #job.txt
    next if /^#/; #отмена операции
    chomp;

    my ($op, $ctg, $phr) = split /\t/;
    next unless $dict{$ctg};

    print STDERR "$op\t$ctg\t$phr\n";

    $ctgs_corr{$ctg} = 1 unless $ctgs_corr{$ctg};
    phr_del($ctg, $phr); #удаление фразы из категории
}

=z
for my $ctg_corr (sort keys %ctgs_corr) { #ОПТИМИЗАЦИИЯ ФРАЗ в категориях
    phr_opt($ctg_corr); #изменяет словарь %dict
}
=cut

for (sort keys %dict) { #новая версия словаря
    print "$_\t$dict{$_}\n";
}


#--- удаление фразы из категории ---
sub phr_del {
    my ($ctg, $phr_del) = @_;

    my $phr_lst = $dict{$ctg}; #список фраз (comma-delimited)
    my @phrs = split /,/, $phr_lst;

    for my $phr (@phrs) {
        #проверка и исправление синтаксиса
        if ($phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
            $phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
            $phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

            $phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
            $phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
        }
        $phr =~ s{\\}{\/}g if $phr =~ m{\\};

        my @wrds = phr_parse($phr); # массив "слов" фразы

        my @wrds_comb; # массив всевозможных комбинаций "слов" фразы (ПРОСТЫЕ фразы)
        my $wrd_pos = 0; # позиция "слова" во фразе
        for my $i (0..$#wrds) {
            my $wrd = $wrds[$i];
            $wrd_pos++;
            my @tmp;
            if ($wrd =~ /^\[/) { #атом
                $wrd =~ s/^\[//;
                $wrd =~ s/\]$//;
                $wrd =~ s/^ +//;
                $wrd =~ s/ +$//;
                for (split m{/}, $wrd) {
                    s/^ +//;
                    s/ +$//;
                    $_ = "[$_]" if /^(hier)?\./; #именованный атом
                    push @tmp, "$wrd_pos\t$_";
                }
                push @tmp, "$wrd_pos\t" if $wrd =~ m{/$};
            } else { #не атом
                push @tmp, "$wrd_pos\t$wrd";
            }
            @wrds_comb = cart_prod_pos(\@wrds_comb, \@tmp);
        }

        for my $wrds_comb (@wrds_comb) { #ПОИСК фразы для удаления
            my @phr_atom; #собранная из анонимных атомов ПРОСТАЯ фраза

            my @a = split /\t/, $wrds_comb;
            for (my $j = 1; $j <= $#a; $j += 2) { #на НЕЧЕТНЫХ местах находятся "слова" (а на четных - номера)
                push @phr_atom, $a[$j];
            }

            my $phr_atom = join(" ", @phr_atom);
            $phr_atom =~ s/^ +//;
            $phr_atom =~ s/ +$//;
            $phr_atom =~ s/  +/ /g;

            $phr_atom = join(" ", sort split(/ +/, $phr_atom)); #не учитываем порядок слов
            $phr_del = join(" ", sort split(/ +/, $phr_del));

            if ($phr_del eq $phr_atom) { #ПРОСТАЯ фраза для удаления найдена, корректируем ИСХОДНУЮ фразу
                print STDERR "$phr\n"; #####
                print STDERR "$wrds_comb\n\n"; #####
                $phr = join(",", phr_corr(\@wrds, \@a)); #ВНОСИМ ИЗМЕНЕНИЯ в массив @phrs
            }
        }

        $phr_lst = join(",", @phrs);
        $phr_lst =~ s/,,/,/g; #удаление ПУСТЫХ фраз

        $dict{$ctg} = $phr_lst; #ВНОСИМ ИЗМЕНЕНИЯ в словарь caddphr_web_ru
    }
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod_pos {
    my ($a, $b) = @_;

    my @prod;
    $$a[0] = "" unless @$a;
    for my $a (@$a) {
        if (@$b > 1) {
            my $atm_pos = 0; # позиция "атома" в "слове"
            for (@$b) {
                $atm_pos++;
                my ($wrd_pos, $wrd) = split /\t/; #позиция "слова" во фразе
                my $tmp = "$wrd_pos,$atm_pos\t$wrd";
                push @prod, $a ? "$a\t$tmp" : $tmp;
            }
        } else {
            push @prod, $a ? "$a\t$$b[0]" : $$b[0];
        }
    }

    return @prod;
}


#--- корректировка фразы ---
sub phr_corr {
    my ($wrds, $a) = @_; #массив "слов" исходной фразы; массив слов удаляемой фразы с номерами позиций (см. cart_prod_pos())

    my @wrds = @$wrds;
    my @a = @$a;

    my @phrs_res; #РЕЗУЛЬТАТ КОРРЕКТИРОВКИ
    my $i = -1; #индекс "слова" в ИСХОДНОМ массиве @wrds
    for (my $j = 0; $j <= $#a; $j += 2) { #на ЧЕТНЫХ местах находятся номера (а на нечетных - "слова")
        $i++;
        if ($wrds[$i] =~ /^\[/) { #анонимный атом
            if ($a[$j] =~ /,/) {
                $a[$j] =~ s/^.*,//; #оставляем число после запятой - позицию "атома" в "слове" (см. cart_prod_pos())
            } else {
                $a[$j] = 1;
            }
            my $k = $a[$j] - 1; #индекс УДАЛЯЕМОГО слова в анонимном атоме

            my $wrd = $wrds[$i];
            $wrd =~ s/^\[//;
            $wrd =~ s/\]$//;
            $wrd =~ s/^ +//;
            $wrd =~ s/ +$//;

            my @wrd = split m{/}, $wrd;
            push @wrd, "" if $wrd =~ m{/$};

            my $atom = join("/", (@wrd[0..$k-1], @wrd[$k+1..$#wrd])); #атом БЕЗ удаленного слова
            $atom = "[".$atom."]" if $atom =~ m{/} || $atom =~ m{^\.};

            my $phrs_res = join(" ", (@wrds[0..$i-1], $atom, @wrds[$i+1..$#wrds]));
            $phrs_res =~ s/  +/ /g;
            push @phrs_res, $phrs_res if $atom || @wrd > 1;

            $wrd[$k] = "[".$wrd[$k]."]" if $wrd[$k] =~ /^\./;
            $wrds[$i] = $wrd[$k]; #удаленное "слово"
        }
    }

    return @phrs_res;
}

########################################################

#--- оптимизациия фраз в категории ---
sub phr_opt {
    my ($ctg) = @_;

    my $flag = 1;
    my $phr_lst = $dict{$ctg}; #список фраз (comma-delimited)
    my @phrs = split /,/, $phr_lst;

    for (@phrs) { #чистка
        s/^ +//;
        s/ +$//;
        s/  +/ /g;
    }

    for my $i (0..$#phrs-1) {
        next if $phrs[$i] =~ /^\*/; #фраза $phrs[$i] уже включена в какую-то фразу
        my @wrdsI = phr_wrds($phrs[$i]); #получение списка "слов" фразы
        my $combI = wrds_comb(\@wrdsI); #генерация массива простых фраз (ссылка на хеш)

        for my $j ($i+1..$#phrs) {
            next if $phrs[$j] =~ /^\*/; #фраза $phrs[$j] уже включена в какую-то фразу
            my @wrdsJ = phr_wrds($phrs[$j]);
            my $combJ = wrds_comb(\@wrdsJ);

            my $ret = phrs_incl($combI, $combJ);
            if ($ret) { #одна из фраз входит в другую
                if ($flag == 1) {
                    $flag = 0;
                    print STDERR "\n*КАТЕГОРИЯ: '$ctg'\n\n"; #категория
                }
                if ($ret == 1) { #фраза $phrs[$j] входит в $phrs[$i]
                    print STDERR "$i\t$phrs[$i]\n";
                    print STDERR "$j\t$phrs[$j]\n";
                    print STDERR "--\n";

                    $phrs[$j] = "*$phrs[$j]";
                } else { #$ret == 2, фраза $phrs[$i] входит в $phrs[$j]
                    print STDERR "$j\t$phrs[$j]\n";
                    print STDERR "$i\t$phrs[$i]\n";
                    print STDERR "--\n";

                    $phrs[$i] = "*$phrs[$i]";
                }
            }
        }
    }

    my @tmp;
    for (@phrs) { #фильтр более мелких подфраз
        push @tmp, $_ unless /^\*/;
    }
 
    $dict{$ctg} = join(",", @tmp); #ВНОСИМ ИЗМЕНЕНИЯ в словарь caddphr_web_ru
}


#--- тест на включение одной фразы вдругую ---
sub phrs_incl {
    my ($a, $b) = @_; #хеши сгенерированных простых фраз

    my $flag = 1;
    for (keys %$b) {
        unless ($$a{$_}) {
            $flag = 0; #фраза %b НЕ входит в %a
            last;
        }
    }
    return 1 if $flag; #фраза %b входит в %a

    for (keys %$a) {
        return 0 unless $$b{$_};
    }
    return 2; #фраза %a входит в %b
}


#--- удаление из массива @a элементов, общих с @b (с учетом количества) ---
sub del_com {
    my ($a, $b) = @_;

    my %h;
    $h{$_}++ for @$b;

    my @a;
    for (@$a) {
        unless ($h{$_}) {
            push @a, $_;
        } else {
            $h{$_}--;
            delete $h{$_} if $h{$_} == 0;
        }
    }

    return @a;
}


#--- получение полного списка простых фраз для фразы ---
sub wrds_comb {
    my ($wrds) = @_; #список "слов" фразы

    my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
    for my $wrd (@$wrds) {
        my @tmp;
        if ($wrd =~ /^\[/) { #атом
            $wrd =~ s/^\[//;
            $wrd =~ s/\]$//;
            $wrd =~ s/^ +//;
            $wrd =~ s/ +$//;
            @tmp = split m{/}, $wrd;
            push @tmp, "" if $wrd =~ m{/$};
        } else { #не атом
            push @tmp, $wrd;
        }
        @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
    }

    my %wrds_comb;
    for my $wrds_comb (@wrds_comb) {
        $wrds_comb =~ s/^ +//;
        $wrds_comb =~ s/ +$//;
        $wrds_comb =~ s/  +/ /g;

        $wrds_comb = join(" ", sort (phr_wrds($wrds_comb)));
        $wrds_comb{$wrds_comb} = 1;
    }

    return \%wrds_comb;
}


#--- получение списка "слов" фразы ---
sub phr_wrds {
    my ($phr) = @_;

    #проверка и исправление синтаксиса
    if ($phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
        $phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
        $phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

        $phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
        $phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
    }
    $phr =~ s{\\}{\/}g if $phr =~ m{\\};

    return phr_parse($phr); #список "слов" фразы
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b, $DEL) = @_;
    $DEL = " " unless $DEL; #разделитель "слов"

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a$DEL$_" : $_ for @$b;
        }
    }

    return @prod;
}
