#!/bin/sh -e
#обнаружение дублей фраз в категориях Каталогии

#формат представления фраз
if [ -z $1 ] || ([ $1 != usual ] && [ $1 != norm ] && [ $1 != snorm ])
then
  phr=usual
else
  phr=$1
fi

#тип выдачи
if [ -z $2 ] || ([ $2 != brief ] && [ $2 != full ])
then
  out=brief
else
  out=$2
fi

echo "Формат представления фраз:" $phr
echo "Тип выдачи:" $out

echo "1. Выбор фраз из Каталогии"
select_phrs.pl >phrs_catalogia 2>/dev/null
#select_phrs_test.pl <caddphr_web_ru >phrs_catalogia #####
select_phrs_test.pl <caddphr_web_ru.tmp >phrs_catalogia #####
LC_ALL=C sort -u phrs_catalogia >phrs_catalogia.s
delete_dupl.pl <phrs_catalogia.s >phrs_catalogia
rm phrs_catalogia.s

echo "2. Печать фраз из категорий с разверткой атомов"
phr_ctgs_expand1.pl $phr <phrs_catalogia >phrs_ctgs_dup.dir 2>/dev/null #---АРГУМЕНТ_1: $phr---
LC_ALL=C sort -u phrs_ctgs_dup.dir >phrs_ctgs_dup.s
delete_dupl.pl <phrs_ctgs_dup.s >phrs_ctgs_dup.dir
rm phrs_ctgs_dup.s

echo "3. Определение пересечения именованных атомов"
atoms_cross.pl >atoms_cross.s 2>/dev/null
LC_ALL=C sort -u atoms_cross.s >atoms_cross
rm atoms_cross.s

echo "4. Вычисление лексических сигнатур для фраз"
words_in_atom.pl <phrs_ctgs_dup.dir >phrs_ctgs_dup.dir2.s 2>/dev/null #построение лексической сигнатуры
LC_ALL=C sort -u phrs_ctgs_dup.dir2.s >phrs_ctgs_dup.dir2
rm phrs_ctgs_dup.dir2.s

echo "5. Развертка фраз с атомами (без учета порядка слов)"
select4expand.pl $out <phrs_ctgs_dup.dir2 >dupl_expanded.s 2>/dev/null #---АРГУМЕНТ_2: $out---
LC_ALL=C sort -u dupl_expanded.s >dupl_expanded
rm dupl_expanded.s

echo "6. Распознавание дублей (без учета порядка слов)"
unorder_dupl.pl <phrs_ctgs_dup.dir >unorder_dupl.s
LC_ALL=C sort -u unorder_dupl.s >unorder_dupl
rm unorder_dupl.s

echo "7. Объединение источников дублей"
LC_ALL=C sort -u dupl_expanded unorder_dupl >phrs_ctgs_dup
rm dupl_expanded unorder_dupl

echo "8. Печать найденных дублей"
sel_dupl.pl <phrs_ctgs_dup >ctgs_dupl 2>/dev/null #не сортировать, т.к. записи упорядочены по специальному ключу для нахождения неупорядоченных дублей
rm phrs_ctgs_dup

echo "Количество дублей:" $[`wc ctgs_dupl |awk '{print $1}'` / 2]

rm atoms_cross
rm ctgs_full_list
rm named_atoms
rm phrs_catalogia
rm phrs_ctgs_dup.dir
rm phrs_ctgs_dup.dir2

#rm ctgs_dupl

