#!/usr/bin/perl -w
#выбор атомов для развертки при поиске дублей в категориях

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';


#--- блок записей для анализа ---
my @recs; #записи
my @words; #слова
my @ctgs; #категории
my @atoms_cnt; #число атомов
my @nums; #номера фраз в категориях

while (my $rec = <STDIN>) { #/home/yuryz/scripts/phrs4ctgs/phrs_dupl/phrs_ctgs_dup.(dir|inv) (результаты phr_ctgs_expand1.pl)
    chomp $rec;

    my ($phr, $ctg, $num) = split /\t/, $rec; #<фраза>, <ID категории>, номер фразы в категории 
    my @wds = phr_parse($phr); #слова фразы

    my $atoms_cnt = 0;
    for (@wds) {
        $atoms_cnt++ if /^\[/; #атом
    }

    my $ret = add_block($rec, \@wds, $ctg, $atoms_cnt, $num); #добавить записи к блоку
    prn_block($rec, \@wds, $ctg, $atoms_cnt, $num) unless $ret; #печать блока
}
prn_block("", "", "", 0, 0);


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- добавление записей к блоку ---
sub add_block {
    my ($rec, $wds, $ctg, $atoms_cnt, $num) = @_; #$wds - ссылка на массив

    if (@recs == 0 || @{$words[0]} == @$wds) {
        push @recs, $rec;
        push @words, $wds;
        push @ctgs, $ctg;
        push @atoms_cnt, $atoms_cnt;
        push @nums, $num;

        return 1;
    }
    return 0;
}


#--- печать блока ---
sub prn_block {
    my ($rec, $wds, $ctg, $atoms_cnt, $num) = @_; #$wds - ссылка на массив

    if (@recs > 1) {
        my $is_atom = 0; #наличие атома в блоке
        for my $i (0..$#recs) {
            if ($atoms_cnt[$i] > 0) {
                $is_atom = 1;
                last;
            }
        }

        if ($is_atom) {
            my $is_diff = 0; #наличие разных категорий в блоке
            for my $i (1..$#recs) {
                if ($ctgs[$i] ne $ctgs[0]) {
                    $is_diff = 1;
                    last;
                }
            }

            if ($is_diff) {
                for my $i (0..$#recs) {
                    next if $atoms_cnt[$i] == 0;
                    for my $j (0..$#recs) {
                        next if $i == $j;
                        if (conj($words[$i], $words[$j])) { #ссылки на массивы "слов"
                            my @tmp = @{$words[$i]};
                            if (@ARGV && $ARGV[0] eq "-i") {
                                @tmp = reverse @tmp;;
                                print join(" ", @tmp), "\t$ctgs[$i]\t$nums[$i]\n" if $tmp[0] =~ /^\[/; #атом
                            } else {
                                print join(" ", @tmp), "\t$ctgs[$i]\t$nums[$i]\n";
                            }
                            last;
                        }
                    }
                }
            }
        }
    }

    @recs = ($rec);
    @words = ($wds);
    @ctgs = ($ctg);
    @atoms_cnt = ($atoms_cnt);
    @nums = ($num);
}


#--- конъюнкция двух кортежей ---
sub conj {
    my ($a, $b) = @_; #ссылки на массивы "слов"
    return 0 if @$a * @$b == 0 || @$a != @$b;
    for my $i (0..$#{$a}) {
        next if $$a[$i] =~ /^\[/ || $$b[$i] =~ /^\[/ || $$a[$i] eq $$b[$i];
        return 0;
    }
    return 1;
}
