#!/usr/bin/perl -w
#выбор фраз, категории которых НЕ находятся в отношении "родитель-ребенок"

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;


my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

#--- блок записей для анализа ---
my @phr; #<фраза>
my @ctg; #<категория>
my @id; #<ID категории>
my @num; #<номер фразы в категории>

while (my $rec = <STDIN>) { #ctgs_dupl_part
    chomp $rec;
    my ($phr, $ctg, $id, $num) = split /\t/, $rec; #<фраза>, <категория>, <ID категории>, <номер фразы в категории>

    my $ret = add_to_block($phr, $ctg, $id, $num); #добавление записи к блоку
    block_proc($phr, $ctg, $id, $num) unless $ret; #обработка блока
    
}
block_proc("", "", "", 0);

#--- добавление записей к блоку ---
sub add_to_block {
    my ($phr, $ctg, $id, $num) = @_;

    if (@phr == 0 || phrs_cmp($phr[0], $phr)) {
        push @phr, $phr;
        push @ctg, $ctg;
        push @id, $id;
        push @num, $num;
        return 1;
    }
    return 0;
}


#--- обработка блока ---
sub block_proc {
    my ($phr, $ctg, $id, $num) = @_;

    if (@phr > 1) {
        my %ind; #индексы записей, категории которых находятся в отношении "родитель-ребенок"
        for my $i (0..$#phr-1) {
            my $parentI = $proj->categs_tree->get_minicateg_parent($ctg[$i]);
            for my $j ($i+1..$#phr) {
                my ($ind_parent, $ind_child) = (-1, -1);

                my $parentJ = $proj->categs_tree->get_minicateg_parent($ctg[$j]);
                if ($ctg[$i] eq $parentJ) {
                    $ind_parent = $i;
                    $ind_child = $j;
                } elsif ($ctg[$j] eq $parentI) {
                    $ind_parent = $j;
                    $ind_child = $i;
                }

                if ($ind_parent >= 0) { #родитель-ребенок
                    my $n = $i + 1;
                    my $m = $j + 1;
                    $ind{$n} = 1 unless $ind{$n};
                    $ind{$m} = 1 unless $ind{$m};
                }
            }
        }

        for my $i (0..$#phr) { #НЕ родитель-ребенок
            my $n = $i + 1;
            unless ($ind{$n}) {
                print "$phr[$i]\t$ctg[$i]\t$id[$i]\t$num[$i]\n";
            }
        }
    }

    #новый блок
    @phr = ($phr);
    @ctg = ($ctg);
    @id = ($id);
    @num = ($num);
}


#--- сравнение фраз ---
sub phrs_cmp {
    my ($a, $b) = @_;

    my @a = phr_parse($a); #слова фразы
    my @b = phr_parse($b);
    return 0 if @a * @b == 0 || @a != @b;

    my %h;
    for (@a) {
        $_ = lc($_) unless /^\[/; # НЕ именованный атом
        $h{$_} = 1;
    }
    for (@b) {
        $_ = lc($_) unless /^\[/; # НЕ именованный атом
        return 0 unless $h{$_};
    }
    return 1;
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}
