#!/usr/bin/perl -w
#печать кластеров дублей из ctgs_dupl_part по заданному сочетанию категорий

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';


my %clust = ( #кластеры для печати
    "-Андрология\tУрология" => 1,
    "-Кабельные системы обогрева - теплый пол, системы антиобледенения и другое оборудование\tЭлектрические кабели, провода и шнуры" => 1,
    "Названия информационных продуктов _ Видеофильмы\tНазвания информационных продуктов _ телесериалы" => 1,
    "-NCAP Легкие внедорожники (premium)\tNCAP Тяжелые внедорожники (premium)" => 1,
    "-Отдых\tОтдых Восточная Европа" => 1,
    "-NCAP Автомобили бизнес класса\tNCAP Автомобили премиум-класса" => 1,
    "-Блендеры\tМиксеры" => 1,
    "-Музыка\tзнаменитости" => 1,
    "-Книги\tзнаменитости" => 1,
    "-Ремонт _ Трансмиссия для автомобилей\tУслуги по ремонту легковых автомобилей" => 1,
    "-Электро- и бензопилы\tЭлектропилы" => 1,
    "-Андрология\tГинекология\tУрология" => 1,
    "-Витамины, минералы, пищевые добавки\tЛекарственные препараты" => 1,
    "-Аксессуары и комплектующие для принтеров и МФУ\tРасходные материалы для компьютерной техники" => 1,
    "-Наборы посуды, сервизы\tПосуда для готовки" => 1,
    "-Оборудование для спутниковой связи, телевидения\tСпутниковое и кабельное телевидение" => 1,
);

#--- блок записей для анализа ---
my @key; #<ключ> (см. select4expand.pl и unorder_dupl.pl)
my @phr; #<фраза>
my @ctg; #<категория>
my @id; #<ID категории>
my @num; #<номер фразы в категории>

while (my $rec = <STDIN>) { #ctgs_dupl_part
    chomp $rec;
    my ($phr, $ctg, $id, $num) = split /\t/, $rec; #<фраза>, <категория>, <ID категории>, <номер фразы в категории>

    my @wds = phr_parse($phr);
    my @key = map { lc($_) } @wds;
    my $key = join(" ", sort @key); # *** добавляем неупорядоченность

    my $ret = add_to_block($key, $phr, $ctg, $id, $num); #добавление записи к блоку
    block_proc($key, $phr, $ctg, $id, $num) unless $ret; #обработка блока
}
block_proc("", "", "", "");


#--- добавление записей к блоку ---
sub add_to_block {
    my ($key, $phr, $ctg, $id, $num) = @_;

    if (@key == 0 || $key[0] eq $key) {
        push @key, $key;
        push @phr, $phr;
        push @ctg, $ctg;
        push @id, $id;
        push @num, $num;
        return 1;
    }
    return 0;
}


#--- обработка блока ---
sub block_proc {
    my ($key, $phr, $ctg, $id, $num) = @_;

    if (@key > 1) {
        my %id;
        for my $i (0..$#key) { #проверка разнообразия категорий
            $id{$id[$i]} = 1;
        }

        if (keys %id > 1) { #в блоке категорий > 1
            %id = ();
            my @clust;
            for my $i (0..$#key) {
                unless ($id{$id[$i]}) { #выводим каждую категорию по 1 разу
                    push @clust, $ctg[$i];
                    $id{$id[$i]} = 1;
                }
            }

            #print join("\t", sort @clust), "\n";
            my $clust = join("\t", sort @clust);
            if ($clust{$clust}) {
                for my $i (0..$#key) {
                    print "$phr[$i]\t$ctg[$i]\t$id[$i]\t$num[$i]\n";
                }
            }
        }
    }

    #новый блок
    @key = ($key);
    @phr = ($phr);
    @ctg = ($ctg);
    @id = ($id);
    @num = ($num);
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}
