#!/usr/bin/perl -w
#печать дублей из разных категорий

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';


#--- блок записей для анализа ---
my @key; #<ключ> (см. select4expand.pl и unorder_dupl.pl)
my @phr; #<фраза>
my @ctg; #<категория>
my @id; #<ID категории>
my @num; #<номер фразы в категории>

while (my $rec = <STDIN>) { #phrs_ctgs_dup
    chomp $rec;
    my ($key, $phr, $ctg, $id, $num) = split /\t/, $rec; #<ключ>, <фраза>, <категория>, <ID категории>, <номер фразы в категории>

    my $ret = add_to_block($key, $phr, $ctg, $id, $num); #добавление записи к блоку
    block_proc($key, $phr, $ctg, $id, $num) unless $ret; #обработка блока
}
block_proc("", "", "", "");


#--- добавление записей к блоку ---
sub add_to_block {
    my ($key, $phr, $ctg, $id, $num) = @_;

    if (@key == 0 || $key[0] eq $key) {
        push @key, $key;
        push @phr, $phr;
        push @ctg, $ctg;
        push @id, $id;
        push @num, $num;
        return 1;
    }
    return 0;
}


#--- обработка блока ---
sub block_proc {
    my ($key, $phr, $ctg, $id, $num) = @_;

    if (@key > 1) {
        my %id;
        for my $i (0..$#key) { #проверка разнообразия категорий
            $id{$id[$i]} = 1;
        }

        if (keys %id > 1) { #в блоке категорий > 1
            %id = ();
            my @clust;
            for my $i (0..$#key) {
                unless ($id{$id[$i]}) { #выводим каждую категорию по 1 разу
                    push @clust, $ctg[$i];
                    $id{$id[$i]} = 1;
                }
            }
            print join("\t", sort @clust), "\n";
        }
    }

    #новый блок
    @key = ($key);
    @phr = ($phr);
    @ctg = ($ctg);
    @id = ($id);
    @num = ($num);
}
