#!/usr/bin/perl -w
#выбор пересечения категорий "Названия информационных продуктов _ Видеофильмы"  и "Названия информационных продуктов _ телесериалы"

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

my %video;
my %serial;
while (<STDIN>) { #../phrs_catalogia
    chomp;
    my ($phr, $id, $num) = split /\t/; #<фраза>, <ID категории>, <номер фразы в категории>

    next unless $id =~ /(200015300|200014589)/; #200015300 - Видеофильмы, 200014589 - телесериалы
    next unless $phr =~ /</; #названия - это мультиворды
    next if $phr =~ /\[.*<[^\[]+?\]/; #если мультиворды - в анонимном атоме

    $phr =~ s/^ +//;
    $phr =~ s/ +$//;
    $phr =~ s/  +/ /g;

    my @wds = phr_parse($phr);
    for my $wd (@wds) {
        if ($wd =~ /^</) { #мультиворды
            if ($id eq "200015300") {
                push @{$video{$wd}}, $_;
            } else {
                push @{$serial{$wd}}, $_;
            }
        }
    }

    #print "$_\n"
}

for my $serial (sort keys %serial) { #печать пересечений
    if ($video{$serial}) {
        for (@{$serial{$serial}}) {
            print "$_\n";
        }
        print "--\n";
        for (@{$video{$serial}}) {
            print "$_\n";
        }
        print "==\n";
    }
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}
