#!/usr/bin/perl -w
#добавление неупорядоченности к обычным фразам

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

while (<STDIN>) { #phrs_ctgs_dup.dir
    chomp;
    my ($phr, $ctg, $id, $num) = split /\t/; #<фраза>, <категория>, <ID категории>, <номер фразы в категории>
    #next if $phr =~ /\[/;

    $phr =~ s/^ +//;
    $phr =~ s/ +$//;
    $phr =~ s/  +/ /g;

    my @wds = phr_parse($phr);
    my @key = map { lc($_) } @wds;
    my $key = join(" ", sort @key); # *** добавляем неупорядоченность

    print "$key\t$_\n"
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}
