#!/usr/bin/perl -w
#развертка дублей

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


my %natoms; #именованные атомы
open F, "named_atoms";
while (<F>) {
    chomp;
    my ($atom, $size) = split /\t/;

    my @phl = atom_named_exp($atom); #фразы атомов
    $natoms{"[$atom]"} = \@phl;

    $proj->clog("$atom\t".(@phl+0), 'green'); #####
}

my %across; #пересечение атомов
open F, "atoms_cross"; #результаты atoms_cross.pl
while (<F>) {
    chomp;
    my ($atom1, $atom2, $word) = split /\t/; #атом1, атом2, общее слово
    push @{$across{"[$atom1]\t[$atom2]"}}, $word;
}

my $rec_count = 0; #####
while (my $rec1 = <STDIN>) { #dupl_collapsed (select4expand.pl)
    chomp $rec1;
    my ($phr1, $ctg1, $num1) = split /\t/, $rec1; #<фраза>, <ID категории>, <номер фразы в категории>
    my $rec2 = <STDIN>;
    chomp $rec2;
    my ($phr2, $ctg2, $num2) = split /\t/, $rec2;

    $rec_count++; #####
    $proj->clog($rec_count, 'green'); #####

    my @wds1 = phr_parse($phr1); #слова фразы
    my @wds2 = phr_parse($phr2);

    my @dupl; # массив всевозможных дублей
    for my $i (0..$#wds1) {
        my @tmp;
        if ($wds1[$i] =~ /^\[/ && $wds2[$i] =~ /^\[/) { #оба слова - атомы
            if ($wds1[$i] eq $wds2[$i]) { #атомы совпадают полностью
                push @tmp, @{$natoms{"$wds1[$i]"}};
                #push @tmp, $wds1[$i]; #при частичной развертке дублей
            } else { #атомы совпадают частично
                push @tmp, @{$across{"$wds1[$i]\t$wds2[$i]"}};
            }
        } elsif ($wds1[$i] =~ /^\[/) {
            push @tmp, $wds2[$i]; #слово
        } elsif ($wds2[$i] =~ /^\[/) {
            push @tmp, $wds1[$i];
        } else { #оба слова - не атомы
            push @tmp, $wds1[$i];
        }
        @dupl = cart_prod(\@dupl, \@tmp);
    }

    for (@dupl) {
        s/^ +//;
        s/ +$//;
        s/  +/ /g;
        print "$_\t$ctg1\t$num1\n";
        print "$_\t$ctg2\t$num2\n";
    }
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b) = @_;

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a $_" : $_ for @$b;
        }
    }

    return @prod;
}


#--- развертка именованного атома ---
sub atom_named_exp {
    my ($atom) = @_;

    my @phl = atom_raw_phrases($atom);
    if (@phl) {
        my @atom_phrs;
        for my $phr (@phl) {
            my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы

            my @wrds = phr_parse($phr); #слова фразы
            for my $wrd (@wrds) {
                my @tmp;
                if ($wrd =~ /^\[/) { #атом
                    $wrd =~ s/^\[//;
                    $wrd =~ s/\]$//;
                    $wrd =~ s/^ +//;
                    $wrd =~ s/ +$//;
                    for (split m{/}, $wrd) {
                        push @tmp, $_;
                    }
                    push @tmp, "" if $wrd =~ m{/$};
                } else { #не атом
                    push @tmp, $wrd;
                }
                @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
            }

            for (@wrds_comb) {
                s/^ +//;
                s/ +$//;
                s/  +/ /g;
            }
            push @atom_phrs, @wrds_comb;
        }
        return @atom_phrs;
    } else {
        return ($atom);
    }
}


#--- "сырые" фразы атома ---
sub atom_raw_phrases {
    my ($atom) = @_;

    my @phrases = ();                                                                                                                                                                                           
    my $category = $atom;                                                                                                                                                                  
    $category =~ s/^hier\./\./; #иерархический атом
    my @bfs_queue = ($category);                                                                                                                                                                                
    while (@bfs_queue) {                                                                                                                                                                                        
        my $root_category = shift(@bfs_queue);                                                                                                                                                                  
        push(@phrases, $proj->get_language('ru')->get_category_raw_phrases($root_category));                                                                                                                    
        push(@bfs_queue, $_) for $proj->categs_tree->get_minicateg_children($root_category);                                                                                                                    
    }
    return @phrases;
}
