#!/usr/bin/perl -w
#выбор всех детей для всех родителей из файла ctgs_parent

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

while (my $rec = <STDIN>) { #ctgs_parent
    chomp $rec;
    my ($id_parent, $ctg_parent) = split /\t/, $rec; #<ID категории родителя>, <категория родителя>
    my @ctgs_child = $proj->categs_tree->get_minicateg_children($ctg_parent); #категории детей
    for my $ctg_child (@ctgs_child) {
        my $id_child = $proj->categs_tree->get_minicateg_directid($ctg_child);
        print "$id_child\t$ctg_child\t$id_parent\n";
    }
}
