#!/usr/bin/perl -w
#выбор "правильной" категории для дублей фраз Каталогии

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


open F, "rus_cities";
chomp(my @cities = <F>);
my $cities = "(".join("|", @cities).")";
my $re_cities = qr/$cities/;

my %phrs;
open F, "phrs_parent_child"; #фразы, для которых нужно выбрать ЕДИНСТВЕННУЮ категорию
while (<F>) {
    chomp;
    my ($phr, $ctg, $id, $num, $ctg_parent, $id_parent, $num_parent) = split /\t/;
    push @{$phrs{$id_parent}}, "$phr\t$ctg\t$id\t$num\t$ctg_parent\t$num_parent";
}

my $prev_id_parent = "";
my @phrs; #фразы, для которых выбрается ЕДИНСТВЕННАЯ категория
my %phrs_num; #номера (не индексы) фраз в @phrs, имеющих надфразы

my $cnt = 0; #####
while (my $rec = <STDIN>) { #phrs4parent (фразы, содержащиеся в детях родителя)
    $cnt++; #####
    print STDERR "$cnt\n" if $cnt % 100 == 0; #####

    chomp $rec;
    my ($phr, $id_parent) = split /\t/, $rec; #ОТСОРТИРОВАН по $id_parent
    my $phr_v = phr_view($phr); #приведение к виду для сравнения

    if ($prev_id_parent ne $id_parent) { #новый родитель
        if ($prev_id_parent) { #вывод результатов для предыдущего родителя
            for my $i (0..$#{$phrs{$prev_id_parent}}) { #ВЫБОР ЕДИНСТВЕННОЙ КАТЕГОРИИ
                my ($phr, $ctg, $id, $num, $ctg_parent, $num_parent) = split /\t/, ${$phrs{$prev_id_parent}}[$i];
                my $n = $i + 1;
                if ($phrs_num{$n}) { #выбор родителя
                    print "P\t$phr\t$ctg_parent\t$num_parent\n";
                    print "C\t$phr\t$ctg\t$num\n";
                    print "--\n";
                } else { #выбор ребенка
                    print "C\t$phr\t$ctg\t$num\n";
                    print "P\t$phr\t$ctg_parent\t$num_parent\n";
                    print "--\n";
                }
            }
        }

        $prev_id_parent = $id_parent;
        @phrs = ();
        %phrs_num = ();
        for my $i (0..$#{$phrs{$prev_id_parent}}) {
            my ($phr, $ctg, $id, $num, $ctg_parent, $num_parent) = split /\t/, ${$phrs{$prev_id_parent}}[$i];
            push @phrs, phr_view($phr); #приведение к виду для сравнения
            #-----
            if ($ctg eq "Гостиницы России" && $ctg_parent eq "Отели, гостиницы") {
                unless ($phr =~ /$re_cities( |$)/) { #поиск в атоме [.Города России]
                    my $n = $i + 1;
                    $phrs_num{$n} = 1; #выбираем родителя
                } else {
                    #print "rus\t$1\n"; #для тестирования словаря городов
                }
            }
            #-----
        }
    }

    for my $i (0..$#phrs) {
        my $n = $i + 1;
        next if $phrs_num{$n};
        if (super_phr($phrs[$i], $phr_v)) { #$phr_v надфраза для $phrs2[$i]
            $phrs_num{$n} = 1; #выбираем родителя
        }
    }
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- приведение фразы к виду для сравнения ---
sub phr_view {
    my ($phr) = @_;

    my @wds = phr_parse($phr);
    for my $j (0..$#wds) {
        $wds[$j] = lc($wds[$j]) unless $wds[$j] =~ /^\[/; # НЕ именованный атом
    }
    return join(" ", @wds);
}


#--- поиск надфразы ---
sub super_phr {
    my ($a, $b) = @_; #$b - надфраза для $a

    my @a = phr_parse($a); #слова фразы
    my @b = phr_parse($b);

    if (@a < @b) {
        my %pos; #номера совпавших позиций
        for my $i (0..$#a) {
            my $flag = 0;
            for my $j (0..$#b) {
                if ($a[$i] eq $b[$j] && !$pos{$j+1}) {
                    $pos{$j+1} = 1; #место занято
                    $flag = 1;
                    last;
                }
            }
            return 0 if $flag == 0;
        }
        return 1;
    }
    return 0;
}
