#!/usr/bin/perl -w
#выбор фраз из phrs_ctgs_dup.dir для всех ДЕТЕЙ из ctgs_children, которые (фразы) содержат слова из wds_parent_child

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my %children;
open F, "ctgs_children";
while (<F>) {
    chomp;
    my ($id, $ctg, $id_parent) = split /\t/;
    $children{$id} = $id_parent;
}

my %words;
open F, "wds_parent_child";
while (<F>) {
    chomp;
    my ($wd, $id_parent) = split /\t/;
    $words{"$wd\t$id_parent"} = 1;
}


my $cnt = 0; #####
while (my $rec = <STDIN>) { #phrs_ctgs_dup.dir
    $cnt++; #####
    print STDERR "$cnt\n" if $cnt % 10000 == 0; #####

    chomp $rec;
    my ($phr, $id, $num) = split /\t/, $rec;
    next unless $children{$id};

    my @wds = phr_parse($phr);
    my $id_parent = "";
    for my $wd (@wds) {
        $wd = lc($wd) unless $wd =~ /^\[/; # НЕ именованный атом
        if ($words{"$wd\t$children{$id}"}) {
            $id_parent = $children{$id}; #ID родителя, для которого собираются слова детей
            last;
        }
    }
    if ($id_parent) {
        print "$phr\t$id_parent\n";
    }
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}
