#!/usr/bin/perl -w
#поиск одинаковых фраз в категориях

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


my %natoms; #именованные атомы
while (<STDIN>) { #/home/yuryz/scripts/phrs4ctgs/phrs_dupl/ctgs_full_list
    chomp;

    my ($ind, $id, $id_parent, $ctg) = split /\t/;
    #next if $ind ne "g0195"; #***ОТЛАДКА

    my $ctg_phrs = $proj->phrase($ctg)->get_category_phrases; #список фраз категорий
    if (@$ctg_phrs) {
        for my $ctg_phr (@$ctg_phrs) {
            #проверка и исправление синтаксиса
            if ($ctg_phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $ctg_phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
                $ctg_phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
                $ctg_phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

                $ctg_phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
                $ctg_phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
            }
            $ctg_phr =~ s{\\}{\/}g if $ctg_phr =~ m{\\};

            #print "$ctg_phr\n";
            my @wrds = phr_parse($ctg_phr); # массив слов и словосочетаний фразы
            my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
            for my $wrd (@wrds) {
                my @tmp;
                if ($wrd =~ /^\[/) { #атом
                    $wrd =~ s/^\[//;
                    $wrd =~ s/\]$//;
                    for (split m{/}, $wrd) {
                        if (/\./) { #возможно именованный атом
                            s/^ +//;
                            s/ +$//;
                            if ($natoms{$_}) { #именованный атом
                                push @tmp, "[$_]";
                            } else {
                                my $phr = $proj->phrase("[$_]");
                                my $phl = $phr->expand_to_phl; #развернутый список фраз
                                if (@$phl > 1) { #именованный атом
                                    push @tmp, "[$_]";
                                    $natoms{$_} = @$phl+0;
                                } else {
                                    push @tmp, $_;
                                }
                            }
                        } else {
                            push @tmp, $_;
                        }
                    }
                    push @tmp, "" if $wrd =~ m{/$};
                } else {
                    push @tmp, $wrd;
                }
                @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
            }

            for my $wrds_comb (@wrds_comb) {
                $wrds_comb =~ s/^ +//;
                $wrds_comb =~ s/ +$//;
                $wrds_comb =~ s/  +/ /g;
                print "$wrds_comb\t$id\n"; #<фраза>, <ID категории>
            }
        }
    }
}

open F, ">named_atoms";
print F "$_\t$natoms{$_}\n" for sort keys %natoms;


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b) = @_;

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a $_" : $_ for @$b;
        }
    }

    return @prod;
}


#--- декартово произведение двух множеств ---
sub cart_prod2 {
    my ($a, $b) = @_;

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a $_" : $_ for @$b;
        }
    }

    return @prod;
}
