#!/usr/bin/perl -w
#печать фраз из категорий с разверткой атомов

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

use Digest::MD5 qw(md5 md5_hex md5_base64);
use Encode;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
    #projsrv => 1, 
});

=z
#$proj = Project->new({projsrv=>1}); print Dumper $proj->categs_tree->get_minicategs_list;
for (@{[$proj->categs_tree->get_minicategs_list]}) { #выдает все категории и все именованные атомы
    print "$_\n" unless /^\./; #пропускаем именованные атомы
}
=cut

`curl https://catmedia.yandex.ru/acgi-bin/interface/get_categs_tree.pl >ctgs_full_list`; #выдает все категории

open my $fh, "ctgs_full_list";
my $ctg_count = 0; #####

while (my $line = <$fh>) {
    $ctg_count++; #####
    chomp $line;

    my ($ind, $id, $id_parent, $ctg) = split /\t/, $line;

    my $ctg_phrs = $proj->phrase($ctg)->get_category_phrases; #список фраз категорий
    my $phr_count = 0; #####

    for my $ctg_phr (@$ctg_phrs) { #свернутые фразы
        $phr_count++; #####
        #$proj->log("$ctg_count\t$phr_count\t$ctg\t$ctg_phr"); #####

        #для сохранения синтаксиса
        $ctg_phr =~ s/\"/%22/g;
        $ctg_phr =~ s/</%3C/g;
        $ctg_phr =~ s/>/%3E/g;
        $ctg_phr =~ s/\{/%7B/g;
        $ctg_phr =~ s/\}/%7D/g;

#---------------------------
#my $flag = 0;
my $phr_count = 1;
my @fact;
while ($ctg_phr =~ m{(\[[^\]]+\])}g) {
#    $flag = 1;
    my $atom = $1;
    my $phr = $proj->phrase($atom);
    my $phl = $phr->expand_to_phl; #развернутый список фраз
    $phr_count *= @$phl;
    push @fact, @$phl+0;
    #print @$phl+0, "\n";
    #print "$1\n";
}
#print "--\n" if $flag;
if ($phr_count > 10000000) {
    print "[@fact]\n";
    print "$phr_count\t$ctg\t$ctg_phr\n";
}
next;
#---------------------------

        my $phr = $proj->phrase($ctg_phr);
        my $phl = $phr->expand_to_phl; #развернутый список фраз

        $proj->clog(scalar @$phl, 'green'); #####

        for (@$phl) { #развернутые фразы
            s/%22/\"/g;
            s/%3C/</g;
            s/%3E/>/g;
            s/%7B/\{/g;
            s/%7D/\}/g;

            s/^ +//;
            s/ +$//;
            s/  +/ /g;

            print md5_base64(encode_utf8($_)), "\t$id\n";
            #print "$_\t$ctg\n";
        }
    }
}
